/*
 * Decompiled with CFR 0.152.
 */
package net.argius;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.argius.frui.Application;
import net.argius.frui.Environment;
import net.argius.frui.IllegalOperationException;
import net.argius.frui.Messages;
import net.argius.frui.Notice;
import net.argius.frui.VerboseMode;
import net.argius.frui.operation.Binary;
import net.argius.frui.operation.Clear;
import net.argius.frui.operation.Condition;
import net.argius.frui.operation.Copy;
import net.argius.frui.operation.Evaluate;
import net.argius.frui.operation.Examine;
import net.argius.frui.operation.Find;
import net.argius.frui.operation.Grep;
import net.argius.frui.operation.GrepZip;
import net.argius.frui.operation.Ignore;
import net.argius.frui.operation.Move;
import net.argius.frui.operation.Name;
import net.argius.frui.operation.OrOperation;
import net.argius.frui.operation.PrintFullPath;
import net.argius.frui.operation.PrintHTML;
import net.argius.frui.operation.PrintLinesNumber;
import net.argius.frui.operation.PrintList;
import net.argius.frui.operation.PrintPath;
import net.argius.frui.operation.PrintQuiet;
import net.argius.frui.operation.PrintSuffixSet;
import net.argius.frui.operation.Replace;
import net.argius.frui.operation.Size;
import net.argius.frui.operation.Time;
import net.argius.frui.operation.Waste;

public final class Frui {
    private static final int STATUS_OK = 0;
    private static final int STATUS_ILLEGAL_OPERATION = 1;
    private static final int STATUS_UNEXPECTED = -1;
    private static final String KEYWORD_SHOTAGE = "shotage";

    private Frui() {
    }

    private static void addCondition(List list, Condition condition, boolean bl) {
        condition.setNegative(bl);
        list.add(condition);
    }

    private static void setDepth(Application application, String string) {
        int n = string.indexOf("..");
        try {
            if (n >= 0) {
                if (n == 0) {
                    String string2 = string.substring("..".length());
                    application.setMaxDepth(Integer.parseInt(string2));
                } else if (string.endsWith("..")) {
                    String string3 = string.substring(0, string.length() - "..".length());
                    application.setMinDepth(Integer.parseInt(string3));
                } else {
                    String string4 = string.substring(0, n);
                    String string5 = string.substring(n + "..".length());
                    application.setMinDepth(Integer.parseInt(string4));
                    application.setMaxDepth(Integer.parseInt(string5));
                }
            } else {
                application.setMaxDepth(Integer.parseInt(string));
            }
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalOperationException(1, string, runtimeException);
        }
    }

    private static void throwException(String string, String string2) {
        throw new IllegalArgumentException(string2 + " : " + string);
    }

    private static String getMessage(String string) {
        return Messages.getString(string);
    }

    private static String getErrorMessage(String string) {
        return Frui.getMessage("usage.error." + string);
    }

    private static int execute(String[] stringArray) {
        OrOperation orOperation;
        if (stringArray.length == 0) {
            Notice.printUsage();
            return 0;
        }
        Application application = new Application();
        OrOperation orOperation2 = orOperation = new ArrayList();
        boolean bl = false;
        boolean bl2 = false;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray2;
            char c;
            String string = stringArray[i];
            if (string.equals("-v") || string.equals("--version")) {
                Notice.printVersion(false);
                return 0;
            }
            if (string.equals("-V") || string.equals("--VERSION")) {
                Notice.printVersion(true);
                return 0;
            }
            if (string.equals("-h") || string.equals("--help")) {
                Notice.printUsage();
                return 0;
            }
            if (string.equals("-d") || string.equals("--directory")) {
                File file;
                if (++i >= n) {
                    Frui.throwException("directory", Frui.getErrorMessage(KEYWORD_SHOTAGE));
                }
                if (!(file = new File(stringArray[i])).isDirectory()) {
                    Frui.throwException(stringArray[i], Frui.getErrorMessage("notdirectory"));
                }
                application.addDirectory(file);
                continue;
            }
            if (string.equals("--depth")) {
                if (++i >= n) {
                    Frui.throwException("depth", Frui.getErrorMessage(KEYWORD_SHOTAGE));
                }
                Frui.setDepth(application, stringArray[i]);
                continue;
            }
            if (string.equals("-i") || string.equals("--stdin")) {
                application.setPiped(true);
                continue;
            }
            if (string.equals("-u") || string.equals("--upper")) {
                if (++i >= n) {
                    Frui.throwException("upper", Frui.getErrorMessage(KEYWORD_SHOTAGE));
                }
                application.setLimit(Integer.parseInt(stringArray[i]));
                continue;
            }
            if (string.equals("--verbose")) {
                application.setVerbose(true);
                continue;
            }
            boolean bl3 = false;
            if (string.equals("!") || string.equals("--not")) {
                if (++i >= n) {
                    throw new IllegalArgumentException(Frui.getErrorMessage("not.illegalposition"));
                }
                string = stringArray[i];
                bl3 = true;
            }
            if (string.equals("-a") || string.equals("--and")) {
                if (orOperation == orOperation2) continue;
                orOperation = orOperation2;
                continue;
            }
            if (string.equals("-o") || string.equals("--or")) {
                if (++i >= n) {
                    throw new IllegalArgumentException(Frui.getErrorMessage("or.illegalposition"));
                }
                orOperation = new OrOperation(bl3);
                orOperation2.add(orOperation);
                string = stringArray[i];
                bl3 = false;
            }
            if (!string.startsWith("-")) {
                Frui.addCondition(orOperation, new Find(string), bl3);
                continue;
            }
            boolean bl4 = false;
            if (string.length() == 3 && string.charAt(2) == 'i' && ((c = string.charAt(1)) == 'c' || c == 'f' || c == 'g' || c == 'm' || c == 'n' || c == 'r' || c == 'z')) {
                string = string.substring(0, 2);
                bl4 = true;
            }
            if (string.equals("-B") || string.equals("--binary")) {
                Frui.addCondition(orOperation, new Binary(), bl3);
                continue;
            }
            if (string.equals("-C") || string.equals("--clear")) {
                Frui.addCondition(orOperation, new Clear(), bl3);
                continue;
            }
            if (string.equals("-f") || string.equals("--find")) {
                if (++i >= n) {
                    Frui.throwException("find", Frui.getErrorMessage(KEYWORD_SHOTAGE));
                }
                Find find = new Find(stringArray[i], bl4);
                Frui.addCondition(orOperation, find, bl3);
                continue;
            }
            if (string.equals("-g") || string.equals("--grep")) {
                if (++i >= n) {
                    Frui.throwException("grep", Frui.getErrorMessage(KEYWORD_SHOTAGE));
                }
                Grep grep = new Grep(stringArray[i], bl4);
                Frui.addCondition(orOperation, grep, bl3);
                continue;
            }
            if (string.equals("-n") || string.equals("--name")) {
                if (++i >= n) {
                    Frui.throwException("name", Frui.getErrorMessage(KEYWORD_SHOTAGE));
                }
                Name name = new Name(stringArray[i], bl4);
                Frui.addCondition(orOperation, name, bl3);
                continue;
            }
            if (string.equals("-r") || string.equals("--replace")) {
                String string2 = stringArray[++i];
                if (++i >= n) {
                    Frui.throwException("replace", Frui.getErrorMessage(KEYWORD_SHOTAGE));
                }
                stringArray2 = new Replace(string2, stringArray[i], bl4);
                orOperation.add(stringArray2);
                bl = true;
                continue;
            }
            if (string.equals("-s") || string.equals("--size")) {
                if (++i >= n) {
                    Frui.throwException("size", Frui.getErrorMessage(KEYWORD_SHOTAGE));
                }
                Frui.addCondition(orOperation, Size.getInstance(stringArray[i]), bl3);
                continue;
            }
            if (string.equals("-t") || string.equals("--time")) {
                if (++i >= n) {
                    Frui.throwException("time", Frui.getErrorMessage(KEYWORD_SHOTAGE));
                }
                Frui.addCondition(orOperation, new Time(stringArray[i]), bl3);
                continue;
            }
            if (string.equals("-T") || string.equals("--text")) {
                Frui.addCondition(orOperation, new Binary(), !bl3);
                continue;
            }
            if (string.equals("-x") || string.equals("--examine")) {
                if (++i >= n) {
                    Frui.throwException("examine", Frui.getErrorMessage(KEYWORD_SHOTAGE));
                }
                Frui.addCondition(orOperation, Examine.getInstance(stringArray[i]), bl3);
                continue;
            }
            if (string.equals("-z") || string.equals("--zip")) {
                if (++i >= n) {
                    Frui.throwException("zip", Frui.getErrorMessage(KEYWORD_SHOTAGE));
                }
                GrepZip grepZip = new GrepZip(stringArray[i], bl4);
                Frui.addCondition(orOperation, grepZip, bl3);
                bl2 = true;
                continue;
            }
            if (bl3) {
                throw new IllegalArgumentException(Frui.getErrorMessage("not.isonlyfilter"));
            }
            if (string.equals("--html")) {
                orOperation.add(new PrintHTML(stringArray));
                continue;
            }
            if (string.equals("-l") || string.equals("--list")) {
                orOperation.add(new PrintList());
                continue;
            }
            if (string.equals("-N") || string.equals("--number")) {
                orOperation.add(new PrintLinesNumber());
                continue;
            }
            if (string.equals("-p") || string.equals("--path")) {
                orOperation.add(new PrintPath());
                continue;
            }
            if (string.equals("-q") || string.equals("--quiet")) {
                orOperation.add(new PrintQuiet());
                continue;
            }
            if (string.equals("--suffix")) {
                orOperation.add(new PrintSuffixSet());
                continue;
            }
            if (string.equals("--fullpath")) {
                orOperation.add(new PrintFullPath());
                continue;
            }
            if (string.equals("-c") || string.equals("--copy")) {
                String string3 = stringArray[++i];
                if (++i >= n) {
                    Frui.throwException("copy", Frui.getErrorMessage(KEYWORD_SHOTAGE));
                }
                orOperation.add(new Copy(string3, stringArray[i], bl4));
                continue;
            }
            if (string.equals("-m") || string.equals("--move")) {
                String string4 = stringArray[++i];
                if (++i >= n) {
                    Frui.throwException("move", Frui.getErrorMessage(KEYWORD_SHOTAGE));
                }
                orOperation.add(new Move(string4, stringArray[i], bl4));
                continue;
            }
            if (string.equals("-w") || string.equals("--waste")) {
                orOperation.add(new Waste());
                continue;
            }
            if (string.equals("-e") || string.equals("--evaluate")) {
                try {
                    char c2;
                    String string5 = stringArray[++i];
                    stringArray2 = new String[]{};
                    if (string5.length() == 1 && Character.isDigit(c2 = string5.charAt(0))) {
                        int n2 = Character.digit(c2, 10);
                        string5 = stringArray[++i];
                        stringArray2 = new String[n2];
                        for (int j = 0; j < n2; ++j) {
                            stringArray2[j] = stringArray[++i];
                        }
                    }
                    orOperation.add(new Evaluate(string5, stringArray2));
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    if (i >= stringArray.length) {
                        Frui.throwException("eval", Frui.getErrorMessage(KEYWORD_SHOTAGE));
                    }
                    throw runtimeException;
                }
            }
            Frui.throwException(string, Frui.getErrorMessage("illegaloption"));
        }
        orOperation = orOperation2;
        if (orOperation.isEmpty()) {
            throw new IllegalArgumentException(Frui.getErrorMessage("hasnocondition"));
        }
        if (bl && bl2) {
            throw new IllegalArgumentException(Frui.getErrorMessage("cannotuse.replacezip"));
        }
        Ignore ignore = new Ignore();
        if (ignore.isEnabled()) {
            orOperation.add(0, ignore);
        }
        if (application.isVerbose()) {
            VerboseMode.invoke(application, orOperation);
        } else {
            application.invoke(orOperation);
        }
        return 0;
    }

    private static void handleOperationError(IllegalOperationException illegalOperationException) {
        String string;
        if (Environment.getBooleanProperty("debug")) {
            illegalOperationException.printStackTrace();
            System.err.println();
        }
        switch (illegalOperationException.getType()) {
            case 0: {
                string = Messages.getString("error.type.property");
                break;
            }
            case 1: {
                string = Messages.getString("error.type.expression");
                break;
            }
            case 2: {
                string = Messages.getString("error.type.io");
                break;
            }
            case 3: {
                string = Messages.getString("error.type.runtime");
                break;
            }
            default: {
                string = Messages.getString("error.type.unknown");
            }
        }
        System.err.println(string + " : " + illegalOperationException.getMessage());
        System.err.println(Messages.getString("error.see.manual"));
    }

    private static void handleFatalError(Throwable throwable) {
        if (Environment.getBooleanProperty("debug")) {
            throwable.printStackTrace();
            System.err.println();
        }
        System.err.print(Messages.getString("error.fatal"));
        String string = throwable.getMessage();
        if (string != null) {
            System.err.print(' ');
            System.err.print(string);
        }
        System.err.println();
    }

    public static void main(String[] stringArray) {
        int n;
        try {
            n = Frui.execute(stringArray);
        }
        catch (IllegalOperationException illegalOperationException) {
            Frui.handleOperationError(illegalOperationException);
            n = 1;
        }
        catch (RuntimeException runtimeException) {
            Frui.handleOperationError(new IllegalOperationException(3, runtimeException.getMessage(), runtimeException));
            n = 1;
        }
        catch (Error error) {
            Frui.handleFatalError(error);
            n = -1;
        }
        if (n != 0) {
            System.exit(n);
        }
    }
}

