package net.argius.frui.operation;

import java.io.*;
import java.text.*;
import java.util.*;

import net.argius.frui.*;

/**
 * t@Cڍ׏̏o͏B
 * o͌`̎B
 */
public final class PrintList extends Print {

    private static final String SPACE19 = "                   ";

    private final String propFileSizeFormatString;
    private final String propDateFormatString;
    private final boolean useFileSizeFormat;
    private final int formatStringLength;

    /**
     * PrintList̐B
     */
    public PrintList() {
        this.propFileSizeFormatString = Utilities.getFileSizeFormatString();
        this.propDateFormatString = Utilities.getDateFormatString();
        this.useFileSizeFormat = propFileSizeFormatString.length() > 0;
        this.formatStringLength = propFileSizeFormatString.length();
    }

    /* (overridden)
     * @see net.argius.frui.operation.Print#printResult(net.argius.frui.FileInfo)
     */
    protected void printInfo(FileInfo fileInfo) throws IOException {
        File file = fileInfo.getFile();
        boolean isDirectory = file.isDirectory();
        // s͖
        StringBuffer buffer = new StringBuffer();
        // directory
        buffer.append(isDirectory ? 'D' : ' ');
        // size
        long length = file.length();
        String fileSize;
        if (useFileSizeFormat) {
            String size;
            if (isDirectory) {
                size = SPACE19;
            } else {
                NumberFormat format = new DecimalFormat(propFileSizeFormatString);
                size = SPACE19 + format.format(length);
            }
            int position = size.length() - formatStringLength;
            fileSize = size.substring(position);
        } else {
            if (isDirectory) {
                fileSize = SPACE19;
            } else {
                fileSize = padLong(length);
            }
        }
        buffer.append(fileSize);
        buffer.append(' ');
        // time
        DateFormat dateFormat = new SimpleDateFormat(propDateFormatString);
        buffer.append(dateFormat.format(new Date(file.lastModified())));
        buffer.append(' ');
        print(buffer);
        println(file);
    }

}