package net.argius.frui.operation;

import java.io.*;
import java.util.*;

import net.argius.frui.*;

/**
 * OR̂߂̌B
 */
public final class OrOperation extends ArrayList implements Operation {

    /**
     * <code>serialVersionUID</code>
     */
    private static final long serialVersionUID = -1655525523048143859L;

    private boolean isNegative;

    /**
     * OrOperation ̐B
     * @param isNegative
     */
    public OrOperation(boolean isNegative) {
        this.isNegative = isNegative;
    }

    /**
     * ےݒ肷B
     * @param isNegative ے̏ꍇ <code>true</code>
     */
    public void setNegative(boolean isNegative) {
        this.isNegative = isNegative;
    }

    /* (overridden)
     * @see java.util.AbstractCollection#toString()
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (isNegative) {
            buffer.append(Constants.LABEL_NOT);
        }
        buffer.append("( ");
        for (int i = 0, n = size(); i < n; i++) {
            if (i != 0) {
                buffer.append(" or ");
            }
            buffer.append(get(i));
        }
        buffer.append(" )");
        return buffer.toString();
    }

    /* (overridden)
     * @see net.argius.frui.Operation#operate(net.argius.frui.FileInfo)
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        boolean result = false;
        for (int i = 0, n = size(); i < n; i++) {
            Operation operation = (Operation)get(i);
            if (operation.operate(fileInfo)) {
                result = true;
                break;
            }
        }
        return isNegative != result;
    }

}