package net.argius.frui.operation;

import java.io.*;

import net.argius.frui.*;

/**
 * t@Cʌ̊NXB
 * t@Cw肳ꂽʂłꍇAuYvƂȂB
 * włʂ͈ȉ̒ʂBi啶͖Bj
 * <pre>
 * D or DIRECTORY - fBNgǂ
 * F or FILE      - t@Cǂ
 * H or HIDDEN    - Bt@Cǂ
 * R or READ      - t@CǍ݉\ǂ
 * W or WRITE     - t@C݉\ǂ
 * </pre>
 */
public abstract class Examine extends Condition {

    /**
     * fBNgǂB
     */
    public static final class DIRECTORY extends Examine {

        protected boolean examine(File file) {
            return file.isDirectory();
        }

    }

    /**
     * t@CǂB
     */
    public static final class FILE extends Examine {

        protected boolean examine(File file) {
            return file.isFile();
        }

    }

    /**
     * Bt@CǂB
     */
    public static final class HIDDEN extends Examine {

        protected boolean examine(File file) {
            return file.isHidden();
        }

    }

    /**
     * t@CǍ݉\ǂB
     */
    public static final class READ extends Examine {

        protected boolean examine(File file) {
            return file.canRead();
        }

    }

    /**
     * t@C݉\ǂB
     */
    public static final class WRITE extends Examine {

        protected boolean examine(File file) {
            return file.canWrite();
        }

    }

    /**
     * CX^X擾B
     * @param type ʖ
     * @return CX^X
     */
    public static Examine getInstance(String type) {
        String upper = type.toUpperCase();
        if (upper.equals("D") || upper.equals("DIRECTORY")) {
            return new DIRECTORY();
        } else if (upper.equals("F") || upper.equals("FILE")) {
            return new FILE();
        } else if (upper.equals("H") || upper.equals("HIDDEN")) {
            return new HIDDEN();
        } else if (upper.equals("R") || upper.equals("READ")) {
            return new READ();
        } else if (upper.equals("W") || upper.equals("WRITE")) {
            return new WRITE();
        }
        throw new IllegalOperationException(IllegalOperationException.EXPRESSION,
                                            type);
    }

    /* (overridden)
     * @see net.argius.frui.Operation#operate(net.argius.frui.FileInfo)
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        return isNegative != examine(fileInfo.getFile());
    }

    /**
     * t@CB
     * @param file t@C
     * @return ɊYꍇ <code>true</code>
     *         YȂꍇ <code>false</code>
     */
    protected abstract boolean examine(File file);

}