package net.argius.frui.operation;

import java.io.*;

import net.argius.frui.*;
import net.argius.frui.io.*;

/**
 * oCit@CB
 * Ώۃt@CoCit@C̏ꍇAuYvƂȂB
 * fBNg͏ɁuYvƂȂB
 */
public final class Binary extends Condition {

    private final boolean detectEncoding;

    /**
     * Binary̐B
     */
    public Binary() {
        detectEncoding = Environment.getBooleanProperty("detect.encoding");
    }

    /* (overridden)
     * @see net.argius.frui.operation.Operation#operate(net.argius.frui.operation.FileInfo)
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        File file = fileInfo.getFile();
        if (file.isDirectory()) {
            return false;
        }
        if (detectEncoding) {
            if (!fileInfo.getEncodingType().isDetected()) {
                fileInfo.setEncodingType(Utilities.detectEncoding(file));
            }
            if (fileInfo.getEncodingType().isDetected()) {
                return isNegative;
            }
        }
        return isNegative != IOUtilities.isBinary(file);
    }

}