package net.argius.frui.io;

import java.io.*;

import net.argius.frui.*;

/**
 * GR[fBO^Cvo̊B
 * t@Ng˂B
 */
public abstract class EncodingTypeDetection {

    /**
     * REPLACEMENT CHARACTER (U+FFFD)
     */
    protected static final char REPLACEMENT_CHARACTER = '\uFFFD';

    /**
     * ӑĂȏSingletonB
     */
    private static class Singleton {

        /**
         * <code>INSTANCE</code>
         */
        protected static final EncodingTypeDetection INSTANCE = createInstance();

    }

    /**
     * CX^X̎擾B
     * @return CX^X
     */
    public static EncodingTypeDetection getInstance() {
        return Singleton.INSTANCE;
    }

    /**
     * CX^X̐B
     * @return CX^X
     */
    protected static EncodingTypeDetection createInstance() {
        try {
            String className = Environment.getProperty("detect.encoding.class");
            return (EncodingTypeDetection)Class.forName(className)
                                               .newInstance();
        } catch (Exception ex) {
            // łException̂͑Ó
            throw new IllegalOperationException(IllegalOperationException.PROPERTY,
                                                "can't initialize EncodingTypeDetection",
                                                ex);
        }
    }

    /**
     * GR[fBO^CvoB
     * @param file oΏۃt@C
     * @return GR[fBO^Cv
     * @throws IOException o̓G[ꍇ
     */
    public EncodingType detect(File file) throws IOException {
        InputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            return detect(is);
        } finally {
            is.close();
        }
    }

    /**
     * GR[fBO^CvoB
     * @param is ̓Xg[
     * @return GR[fBO^Cv
     * @throws IOException o̓G[ꍇ
     */
    public abstract EncodingType detect(InputStream is) throws IOException;

}