package net.argius.frui;

import net.argius.version.*;

/**
 * B
 * wvo[WȂǂo͂B
 */
public final class Notice {

    private static final int TYPE_NO = 0xC0000;
    private static final int TYPE_FILTER = 0xC0001;
    private static final int TYPE_MOVE = 0xC0002;
    private static final int TYPE_OUTPUT = 0xC0003;
    private static final int TYPE_MODE = 0xC0004;
    private static final int TYPE_INFO = 0xC0005;
    private static final int TYPE_OTHERS = 0xC00FF;

    /**
     * Frui̐B
     */
    private Notice() {
        // empty
    }

    /**
     * o[Wo͂B
     * @param isFull S\ꍇ <code>true</code>
     */
    public static void printVersion(boolean isFull) {
        Version version = Version.getInstance(Notice.class);
        if (isFull) {
            System.out.println(Constants.PRODUCT_DETAIL_NAME
                               + " - version "
                               + version.getFullString());
        } else {
            System.out.println(Constants.PRODUCT_NAME
                               + ' '
                               + version.getRegularString());
        }
    }

    /**
     * go͂B
     */
    public static void printUsage() {
        if (Environment.getBooleanProperty("debug")) {
            System.err.println("JavaVM : "
                               + System.getProperty("java.vm.vendor")
                               + ' '
                               + System.getProperty("java.vm.name")
                               + ' '
                               + System.getProperty("java.vm.version"));
            System.err.println();
        }
        // usage 1 
        System.err.println(getUsageMessage("title")
                           + Constants.MESSAGE_SEPARATOR
                           + getUsageMessage("format"));
        System.err.println();
        // usage 2
        System.err.println(getUsageMessage("description.1"));
        System.err.println(getUsageMessage("description.2"));
        System.err.println(getUsageMessage("description.3"));
        System.err.println();
        // usage 3
        System.err.println(getUsageMessage("description.4"));
        System.err.println();
        // usage 4
        showOption('a', "and", 0, TYPE_FILTER);
        showOption('B', "binary", 0, TYPE_FILTER);
        showOption('c', "copy", 2, TYPE_MOVE);
        showOption('C', "clear", 0, TYPE_FILTER);
        showOption('d', "directory", 1, TYPE_MODE);
        showOption(' ', "depth", 1, TYPE_MODE);
        showOption('e', "evaluate", 1, TYPE_OTHERS);
        showOption('f', "find", 1, TYPE_FILTER);
        showOption(' ', "fullpath", 0, TYPE_OUTPUT);
        showOption('g', "grep", 1, TYPE_FILTER);
        showOption('h', "help", 0, TYPE_INFO);
        showOption(' ', "html", 0, TYPE_OUTPUT);
        showOption('i', "stdin", 0, TYPE_MODE);
        showOption('l', "list", 0, TYPE_OUTPUT);
        showOption('m', "move", 2, TYPE_MOVE);
        showOption('!', "not", 0, TYPE_FILTER);
        showOption('n', "name", 1, TYPE_FILTER);
        showOption('N', "number", 0, TYPE_OUTPUT);
        showOption('o', "or", 0, TYPE_FILTER);
        showOption('p', "path", 0, TYPE_OUTPUT);
        showOption('q', "quiet", 0, TYPE_OUTPUT);
        showOption('r', "replace", 2, TYPE_FILTER);
        showOption('s', "size", 1, TYPE_FILTER);
        showOption(' ', "suffix", 0, TYPE_OUTPUT);
        showOption('t', "time", 1, TYPE_FILTER);
        showOption('T', "text", 0, TYPE_FILTER);
        showOption('u', "upper", 1, TYPE_MODE);
        showOption('v', "version", 0, TYPE_INFO);
        showOption('V', "VERSION", 0, TYPE_INFO);
        showOption(' ', "verbose", 0, TYPE_MODE);
        showOption('w', "waste", 0, TYPE_MOVE);
        showOption('x', "examine", 1, TYPE_FILTER);
        showOption('z', "zip", 1, TYPE_FILTER);
        System.err.println();
    }

    /**
     * IvV̐\B
     * @param shorten R}hZk
     * @param full R}h(L[[h)
     * @param parameterCount p[^
     * @param type 
     */
    private static void showOption(char shorten,
                                   String full,
                                   int parameterCount,
                                   int type) {
        StringBuffer buffer = new StringBuffer(32);
        int position = 0;
        // indent
        position += 4;
        appendSpace(buffer, position);
        // shorten
        position += 4;
        if (shorten == '!') {
            buffer.append(' ');
        } else if (shorten != ' ') {
            buffer.append('-');
        }
        buffer.append(shorten);
        appendSpace(buffer, position);
        // full
        position += 12;
        buffer.append("--");
        buffer.append(full);
        appendSpace(buffer, position);
        // parameter count
        position += 4;
        buffer.append('(');
        buffer.append(parameterCount);
        buffer.append(')');
        appendSpace(buffer, position);
        // type
        position += 8;
        switch (type) {
            case TYPE_NO:
                buffer.append(getUsageMessage("type.no"));
                break;
            case TYPE_FILTER:
                buffer.append(getUsageMessage("type.filter"));
                break;
            case TYPE_MOVE:
                buffer.append(getUsageMessage("type.move"));
                break;
            case TYPE_OUTPUT:
                buffer.append(getUsageMessage("type.output"));
                break;
            case TYPE_MODE:
                buffer.append(getUsageMessage("type.mode"));
                break;
            case TYPE_INFO:
                buffer.append(getUsageMessage("type.info"));
                break;
            case TYPE_OTHERS:
                buffer.append(getUsageMessage("type.others"));
                break;
            default:
        }
        appendSpace(buffer, position);
        // description
        buffer.append(Constants.MESSAGE_SEPARATOR);
        buffer.append(getUsageMessage("explanation." + full));
        // print line
        System.err.println(buffer);
    }

    /**
     * obt@ɃXy[X𖄂߂B
     * @param buffer obt@
     * @param demand 
     */
    private static void appendSpace(StringBuffer buffer, int demand) {
        int lack = demand - buffer.toString().getBytes().length;
        for (int i = 0, n = lack; i < n; i++) {
            buffer.append(' ');
        }
    }

    /**
     * bZ[W擾B
     * @param keyword bZ[W̃L[[h
     * @return bZ[W
     */
    private static String getMessage(String keyword) {
        return Messages.getString(keyword);
    }

    /**
     * gp@bZ[W擾B
     * @param keyword gp@bZ[W̃L[[h
     * @return gp@bZ[W
     */
    private static String getUsageMessage(String keyword) {
        return getMessage("usage." + keyword);
    }

}