/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.argius.frui.Environment;
import net.argius.frui.IllegalOperationException;
import net.argius.frui.io.EncodingType;

public abstract class EncodingTypeDetection {
    protected static final char REPLACEMENT_CHARACTER = '\ufffd';

    public static EncodingTypeDetection getInstance() {
        return Singleton.INSTANCE;
    }

    protected static EncodingTypeDetection createInstance() {
        try {
            String string = Environment.getProperty("detect.encoding.class");
            return (EncodingTypeDetection)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new IllegalOperationException(0, "can't initialize EncodingTypeDetection", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncodingType detect(File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            EncodingType encodingType = this.detect(bufferedInputStream);
            return encodingType;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    public abstract EncodingType detect(InputStream var1) throws IOException;

    private static class Singleton {
        protected static final EncodingTypeDetection INSTANCE = EncodingTypeDetection.createInstance();

        private Singleton() {
        }
    }
}

