/*
 * Decompiled with CFR 0.152.
 */
package net.argius;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.argius.frui.Application;
import net.argius.frui.FileInfo;
import net.argius.frui.Operation;
import net.argius.frui.operation.Collector;

public final class FruiRunner {
    private final Application application = new Application();
    private final Operation[] operations;
    private final File[] roots;

    public FruiRunner(Operation[] operationArray) {
        this(Arrays.asList(operationArray), new File[0]);
    }

    public FruiRunner(Operation[] operationArray, File file) {
        this(Arrays.asList(operationArray), new File[]{file});
    }

    public FruiRunner(Operation[] operationArray, File[] fileArray) {
        this(Arrays.asList(operationArray), fileArray);
    }

    public FruiRunner(List list) {
        this(list, new File[0]);
    }

    public FruiRunner(List list, File file) {
        this(list, new File[]{file});
    }

    public FruiRunner(List list, File[] fileArray) {
        this.operations = list.toArray(new Operation[list.size()]);
        this.roots = (File[])fileArray.clone();
    }

    public void setMaxDepth(int n) {
        this.application.setMaxDepth(n);
    }

    public void setMinDepth(int n) {
        this.application.setMinDepth(n);
    }

    public void setLimit(int n) {
        this.application.setLimit(n);
    }

    public String[] getPaths() {
        return FruiRunner.getPaths(this.application, this.operations, this.roots);
    }

    public File[] getFiles() {
        return FruiRunner.getFiles(this.application, this.operations, this.roots);
    }

    public FileInfo[] getFileInfos() {
        return FruiRunner.getFileInfos(this.application, this.operations, this.roots);
    }

    public void start() {
        FruiRunner.start(this.application, this.operations, this.roots);
    }

    public static String[] getPaths(List list) {
        return FruiRunner.getPaths(list, new File[0]);
    }

    public static String[] getPaths(List list, File file) {
        return FruiRunner.getPaths(list, new File[]{file});
    }

    public static String[] getPaths(List list, File[] fileArray) {
        Operation[] operationArray = list.toArray(new Operation[list.size()]);
        return FruiRunner.getPaths(operationArray, fileArray);
    }

    public static String[] getPaths(Operation[] operationArray) {
        return FruiRunner.getPaths(operationArray, new File[0]);
    }

    public static String[] getPaths(Operation[] operationArray, File file) {
        return FruiRunner.getPaths(operationArray, new File[]{file});
    }

    public static String[] getPaths(Operation[] operationArray, File[] fileArray) {
        return FruiRunner.getPaths(new Application(), operationArray, fileArray);
    }

    private static String[] getPaths(Application application, Operation[] operationArray, File[] fileArray) {
        FileInfo[] fileInfoArray = FruiRunner.getFileInfos(application, operationArray, fileArray);
        String[] stringArray = new String[fileInfoArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = fileInfoArray[i].getFile().getPath();
        }
        return stringArray;
    }

    public static File[] getFiles(List list) {
        return FruiRunner.getFiles(list, new File[0]);
    }

    public static File[] getFiles(List list, File file) {
        return FruiRunner.getFiles(list, new File[]{file});
    }

    public static File[] getFiles(List list, File[] fileArray) {
        Operation[] operationArray = list.toArray(new Operation[list.size()]);
        return FruiRunner.getFiles(operationArray, fileArray);
    }

    public static File[] getFiles(Operation[] operationArray) {
        return FruiRunner.getFiles(operationArray, new File[0]);
    }

    public static File[] getFiles(Operation[] operationArray, File file) {
        return FruiRunner.getFiles(operationArray, new File[]{file});
    }

    public static File[] getFiles(Operation[] operationArray, File[] fileArray) {
        return FruiRunner.getFiles(new Application(), operationArray, fileArray);
    }

    private static File[] getFiles(Application application, Operation[] operationArray, File[] fileArray) {
        FileInfo[] fileInfoArray = FruiRunner.getFileInfos(application, operationArray, fileArray);
        File[] fileArray2 = new File[fileInfoArray.length];
        for (int i = 0; i < fileArray2.length; ++i) {
            fileArray2[i] = fileInfoArray[i].getFile();
        }
        return fileArray2;
    }

    public static FileInfo[] getFileInfos(List list) {
        return FruiRunner.getFileInfos(list, new File[0]);
    }

    public static FileInfo[] getFileInfos(List list, File file) {
        return FruiRunner.getFileInfos(list, new File[]{file});
    }

    public static FileInfo[] getFileInfos(List list, File[] fileArray) {
        Operation[] operationArray = list.toArray(new Operation[list.size()]);
        return FruiRunner.getFileInfos(operationArray, fileArray);
    }

    public static FileInfo[] getFileInfos(Operation[] operationArray) {
        return FruiRunner.getFileInfos(operationArray, new File[0]);
    }

    public static FileInfo[] getFileInfos(Operation[] operationArray, File file) {
        return FruiRunner.getFileInfos(operationArray, new File[]{file});
    }

    public static FileInfo[] getFileInfos(Operation[] operationArray, File[] fileArray) {
        return FruiRunner.getFileInfos(new Application(), operationArray, fileArray);
    }

    private static FileInfo[] getFileInfos(Application application, Operation[] operationArray, File[] fileArray) {
        Collector collector = new Collector();
        application.setDirectories(fileArray);
        application.invoke(operationArray, collector);
        return collector.getFileInfos();
    }

    public static void start(List list) {
        FruiRunner.start(list, new File[0]);
    }

    public static void start(List list, File file) {
        FruiRunner.start(list, new File[]{file});
    }

    public static void start(List list, File[] fileArray) {
        Operation[] operationArray = list.toArray(new Operation[list.size()]);
        FruiRunner.start(operationArray, fileArray);
    }

    public static void start(Operation[] operationArray) {
        FruiRunner.start(operationArray, new File[0]);
    }

    public static void start(Operation[] operationArray, File file) {
        FruiRunner.start(operationArray, new File[]{file});
    }

    public static void start(Operation[] operationArray, File[] fileArray) {
        FruiRunner.start(new Application(), operationArray, fileArray);
    }

    private static void start(Application application, Operation[] operationArray, File[] fileArray) {
        application.setDirectories(fileArray);
        application.invoke(operationArray);
    }
}

