/**
 * 
 */
package net.argius.frui.text;

import java.util.*;

/**
 * v(񐳋K\)p^[B
 */
public final class StringMatcher implements Pattern {

    private final String expression;
    private final StringFinder finder;

    /**
     * StringMatcher̐B
     * @param expression p^[\
     */
    public StringMatcher(String expression) {
        this(expression, false);
    }

    /**
     * StringMatcher̐B
     * @param expression p^[\
     * @param isIgnoreCase 啶𖳎ꍇ <code>true</code>
     */
    public StringMatcher(String expression, boolean isIgnoreCase) {
        this.expression = expression;
        if (isIgnoreCase && expression.length() > 0) {
            finder = new StringIgnoreCaseFinder(expression);
        } else {
            finder = new StringCaseSensitiveFinder(expression);
        }
    }

    /* (non-Javadoc)
     * @see net.argius.frui.text.Pattern#find(java.lang.String)
     */
    public boolean find(String input) {
        return finder.find(input) >= 0;
    }

    /* (non-Javadoc)
     * @see net.argius.frui.text.Pattern#matches(java.lang.String)
     */
    public boolean matches(String input) {
        return expression.length() == input.length() && finder.find(input) == 0;
    }

    /* (non-Javadoc)
     * @see net.argius.frui.text.Pattern#pattern()
     */
    public String pattern() {
        return expression;
    }

    /* (non-Javadoc)
     * @see net.argius.frui.text.Pattern#replaceAll(java.lang.String, java.lang.String)
     */
    public String replaceAll(String input, String replacement) {
        final int length = expression.length();
        if (input.length() <= 0 || length <= 0) {
            return input;
        }
        int index = finder.find(input);
        if (index == StringFinder.NOT_FOUND) {
            return input;
        }
        StringBuffer buffer = new StringBuffer(input);
        while (index != StringFinder.NOT_FOUND) {
            buffer.replace(index, index + length, replacement);
            index = finder.find(input, index + length);
        }
        return buffer.toString();
    }

    /* (non-Javadoc)
     * @see net.argius.frui.text.Pattern#replaceFirst(java.lang.String, java.lang.String)
     */
    public String replaceFirst(String input, String replacement) {
        int index = finder.find(input);
        if (index == StringFinder.NOT_FOUND) {
            return input;
        } else {
            StringBuffer buffer = new StringBuffer(input);
            buffer.replace(index, index + expression.length(), replacement);
            return buffer.toString();
        }
    }

    /* (non-Javadoc)
     * @see net.argius.frui.text.Pattern#split(java.lang.String)
     */
    public String[] split(String input) {
        final int length = expression.length();
        if (length <= 0) {
            int size = input.length();
            String[] result = new String[size + 1];
            result[0] = "";
            for (int i = 0; i < size; i++) {
                result[i + 1] = String.valueOf(input.charAt(i));
            }
            return result;
        }
        int index = finder.find(input);
        int offset = 0;
        List list = new ArrayList();
        while (index != StringFinder.NOT_FOUND) {
            if (offset == 0 || offset < index) {
                list.add(input.substring(offset, index));
            }
            offset = index + length;
            index = finder.find(input, offset);
        }
        if (offset < input.length()) {
            list.add(input.substring(offset));
        }
        return (String[])list.toArray(new String[list.size()]);
    }

    /* (overridden)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('"');
        buffer.append(expression);
        buffer.append('"');
        if (finder instanceof StringIgnoreCaseFinder) {
            buffer.append('i');
        }
        return buffer.toString();
    }

}
