package net.argius.frui.text;

import java.util.regex.*;

/**
 * K\p^[̃t@NgB
 * @see java.util.regex.Pattern
 */
public final class PatternFactory {

    private static final java.util.regex.Pattern PATTERN1 = java.util.regex.Pattern.compile("^/([^/].*)/([A-Za-z]*)$");

    /**
     * PatternFactory̐B
     */
    private PatternFactory() {
        // empty
    }

    /**
     * K\p^[𐶐B
     * @param expression p^[\
     * @return K\p^[
     * @throws PatternException p^[񂪐K\ƂĐȂꍇ
     */
    public static Pattern create(String expression) throws PatternException {
        return create(expression, false);
    }

    /**
     * K\p^[𐶐B
     * @param expression p^[\
     * @param isIgnoreCase 
     * @return K\p^[
     * @throws PatternException p^[񂪐K\ƂĐȂꍇ
     */
    public static Pattern create(String expression, boolean isIgnoreCase) throws PatternException {
        String pattern;
        int flags = 0;
        Matcher matcher = PATTERN1.matcher(expression);
        if (matcher.find()) {
            pattern = matcher.group(1);
            String flagsString = matcher.group(2);
            if (flagsString != null) {
                if (flagsString.indexOf('d') >= 0) {
                    flags |= Pattern.UNIX_LINES;
                }
                if (flagsString.indexOf('i') >= 0 || isIgnoreCase) {
                    flags |= Pattern.CASE_INSENSITIVE;
                }
                if (flagsString.indexOf('x') >= 0) {
                    flags |= Pattern.COMMENTS;
                }
                if (flagsString.indexOf('m') >= 0) {
                    flags |= Pattern.MULTILINE;
                }
                if (flagsString.indexOf('s') >= 0) {
                    flags |= Pattern.DOTALL;
                }
                if (flagsString.indexOf('u') >= 0) {
                    flags |= Pattern.UNICODE_CASE;
                }
            }
            return new PatternMatcher(expression, pattern, flags);
        } else {
            return new StringMatcher(expression, isIgnoreCase);
        }
    }

}