package net.argius.frui.operation;

import java.io.*;

import net.argius.frui.*;

/**
 * t@Cs̏o͏B
 * o͌`̎B
 */
public final class PrintLinesNumber extends Print {

    /* (overridden)
     * @see net.argius.frui.operation.Print#printResult(net.argius.frui.FileInfo)
     */
    protected void printInfo(FileInfo fileInfo) throws IOException {
        File file = fileInfo.getFile();
        if (file.isDirectory()) {
            return;
        }
        int count = fileInfo.getLineInfoList().size();
        int linesNumber = (count > 0) ? count : getLinesNumber(file);
        StringBuffer buffer = new StringBuffer();
        // number of lines
        buffer.append(padInt(linesNumber));
        buffer.append(' ');
        print(buffer);
        println(file);
    }

    /**
     * t@C̍s擾B
     * @param file t@C
     * @return t@C̍s
     * @throws IOException o̓G[ꍇ
     */
    private static int getLinesNumber(File file) throws IOException {
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
        try {
            while (true) {
                if (lineNumberReader.readLine() == null) {
                    break;
                }
            }
            return lineNumberReader.getLineNumber();
        } finally {
            lineNumberReader.close();
        }
    }

}