package net.argius.frui.io;

import java.io.*;
import java.text.*;
import java.util.*;

import net.argius.frui.*;

/**
 * (U)B
 */
public final class WasteBasket {

    private final String name;
    private final File directory;

    /**
     * WasteBasket̐B
     * @param root ̃pX
     */
    public WasteBasket(String root) {
        this(new File(root));
    }

    /**
     * WasteBasket̐B
     * @param root ̃pX
     */
    public WasteBasket(File root) {
        if (!root.exists()) {
            String message = Messages.getString("error.nonexistent.directory")
                             + Constants.MESSAGE_SEPARATOR
                             + root;
            throw new IllegalOperationException(IllegalOperationException.IO,
                                                message);
        }
        Date date = new Date();
        String dateString = new SimpleDateFormat("yyyyMMdd").format(date);
        String timeString = new SimpleDateFormat("HHmmss").format(date);
        this.name = "waste:/" + dateString + '/' + timeString;
        this.directory = new File(new File(root, dateString), timeString);
    }

    /**
     * fBNg̎擾B
     * @return fBNg
     */
    public File getDirectory() {
        return directory;
    }

    /* (overridden)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return name;
    }

}