/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.text;

import java.util.ArrayList;
import net.argius.frui.text.Pattern;
import net.argius.frui.text.StringCaseSensitiveFinder;
import net.argius.frui.text.StringFinder;
import net.argius.frui.text.StringIgnoreCaseFinder;

public final class StringMatcher
implements Pattern {
    private final String expression;
    private final StringFinder finder;

    public StringMatcher(String string) {
        this(string, false);
    }

    public StringMatcher(String string, boolean bl) {
        this.expression = string;
        this.finder = bl && string.length() > 0 ? new StringIgnoreCaseFinder(string) : new StringCaseSensitiveFinder(string);
    }

    public boolean find(String string) {
        return this.finder.find(string) >= 0;
    }

    public boolean matches(String string) {
        return this.expression.length() == string.length() && this.finder.find(string) == 0;
    }

    public String pattern() {
        return this.expression;
    }

    public String replaceAll(String string, String string2) {
        int n = this.expression.length();
        if (string.length() <= 0 || n <= 0) {
            return string;
        }
        int n2 = this.finder.find(string);
        if (n2 == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (n2 != -1) {
            stringBuffer.replace(n2, n2 + n, string2);
            n2 = this.finder.find(string, n2 + n);
        }
        return stringBuffer.toString();
    }

    public String replaceFirst(String string, String string2) {
        int n = this.finder.find(string);
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.replace(n, n + this.expression.length(), string2);
        return stringBuffer.toString();
    }

    public String[] split(String string) {
        int n = this.expression.length();
        if (n <= 0) {
            int n2 = string.length();
            String[] stringArray = new String[n2 + 1];
            stringArray[0] = "";
            for (int i = 0; i < n2; ++i) {
                stringArray[i + 1] = String.valueOf(string.charAt(i));
            }
            return stringArray;
        }
        int n3 = this.finder.find(string);
        int n4 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n3 != -1) {
            if (n4 == 0 || n4 < n3) {
                arrayList.add(string.substring(n4, n3));
            }
            n4 = n3 + n;
            n3 = this.finder.find(string, n4);
        }
        if (n4 < string.length()) {
            arrayList.add(string.substring(n4));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        stringBuffer.append(this.expression);
        stringBuffer.append('\"');
        if (this.finder instanceof StringIgnoreCaseFinder) {
            stringBuffer.append('i');
        }
        return stringBuffer.toString();
    }
}

