/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.argius.frui.io.EncodingType;
import net.argius.frui.io.EncodingTypeDetection;

public class JapaneseEncodingTypeDetection
extends EncodingTypeDetection {
    private static final String ISO8859_1 = "ISO8859-1";
    private static final String ISO2022JP = "ISO2022JP";
    private static final String EUC_JP = "EUC_JP";
    private static final String SHIFT_JIS = "Shift_JIS";
    private static final String MS932 = "MS932";
    private static final String UTF_8 = "UTF-8";
    private static final String UTF_16 = "UTF-16";
    private static final int LIMIT = 0x200000;

    public EncodingType detect(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray)) >= 0) {
            if (byteArrayOutputStream.size() + n > 0x200000) {
                bl = true;
                break;
            }
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (this.isAscii(byArray2)) {
            return new EncodingType(ISO8859_1, true);
        }
        String[] stringArray = new String[]{ISO2022JP, EUC_JP, SHIFT_JIS, MS932, UTF_8, UTF_16};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = new String(byArray2, string);
            if (bl) {
                string2 = string2.substring(0, string2.length() - 16);
            }
            if (JapaneseEncodingTypeDetection.hasUnassignedCode(string2)) continue;
            return new EncodingType(string, true);
        }
        return EncodingType.DEFAULT;
    }

    private boolean isAscii(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if ((by >= 32 || by == 9 || by == 10 || by == 12 || by == 13) && 126 >= by) continue;
            return false;
        }
        return true;
    }

    private static boolean hasUnassignedCode(CharSequence charSequence) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (c < ' ' && c != '\t' && c != '\n' && c != '\f' && c != '\r') {
                return true;
            }
            if (c != '\ufffd') continue;
            return true;
        }
        return false;
    }
}

