/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IOUtilities {
    private static final int REASON_UNKNOWN = 917504;
    private static final int REASON_ALREADY_EXISTS = 917505;

    private IOUtilities() {
    }

    public static boolean move(File file, File file2, boolean bl) throws IOException {
        if (file2.exists()) {
            if (bl) {
                file2.delete();
            } else {
                IOUtilities.throwIOException("move", file2, 917505);
            }
        }
        IOUtilities.mkdirsIfNotExists(file2);
        return file.renameTo(file2);
    }

    public static void copy(File file, File file2, boolean bl) throws IOException {
        if (file2.exists() && !bl) {
            IOUtilities.throwIOException("copy", file2, 917505);
        }
        IOUtilities.copy(file, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2) throws IOException {
        long l = file.lastModified();
        IOUtilities.mkdirsIfNotExists(file2);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                IOUtilities.copy(fileInputStream, fileOutputStream);
            }
            finally {
                fileInputStream.close();
            }
        }
        finally {
            fileOutputStream.close();
        }
        file2.setLastModified(l);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBinary(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            boolean bl = IOUtilities.isBinary(fileInputStream);
            return bl;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public static boolean isBinary(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
            if ((n2 += n) <= 65552) continue;
        }
        char[] cArray = new String(byteArrayOutputStream.toByteArray()).toCharArray();
        int n3 = Math.min(cArray.length, 65536);
        for (int i = 0; i < n3; ++i) {
            char c = cArray[i];
            if ((c >= ' ' || c == '\t' || c == '\n' || c == '\r') && c != '\ufffd') continue;
            return true;
        }
        return false;
    }

    private static void mkdirsIfNotExists(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists() && !file2.mkdirs()) {
            IOUtilities.throwIOException("mkdir", file, 917504);
        }
    }

    private static void throwIOException(String string, File file, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("error to ");
        stringBuffer.append(string);
        stringBuffer.append('(');
        stringBuffer.append(file);
        stringBuffer.append(") : ");
        switch (n) {
            case 917505: {
                stringBuffer.append("file already exists");
                break;
            }
            default: {
                stringBuffer.append("unknown error");
            }
        }
        throw new IOException(stringBuffer.toString());
    }
}

