package net.argius.frui.text;

/**
 * 啶̈Ⴂ𖳎镶񌟍B
 */
final class StringIgnoreCaseFinder implements StringFinder {

    private final String string;
    private final char initial;
    private final int length;

    /**
     * StringIgnoreCaseFinder̐B
     * @param string 镶
     */
    public StringIgnoreCaseFinder(String string) {
        this.string = string;
        this.initial = Character.toUpperCase(string.charAt(0));
        this.length = string.length();
    }

    /* (overridden)
     * @see net.argius.frui.text.StringFinder#find(java.lang.String)
     */
    public int find(String s) {
        return find(s, 0);
    }

    /* (overridden)
     * @see net.argius.frui.text.StringFinder#find(java.lang.String, int)
     */
    public int find(String s, int index) {
        final int length = s.length();
        if (length <= index || length < this.length) {
            return NOT_FOUND;
        }
        final int limit = length - this.length + 1;
        for (int i = index; i < limit; i++) {
            char c = Character.toUpperCase(s.charAt(i));
            if (c == initial) {
                String sample = s.substring(i, i + this.length);
                if (sample.equalsIgnoreCase(string)) {
                    return i;
                }
            }
        }
        return NOT_FOUND;
    }

}