package net.argius.frui.operation;

import java.io.*;

import net.argius.frui.*;

/**
 * t@CTCY̊NXB
 * Ώۃt@CTCY擾A
 * wTCYƂ̔r͎NXɔCB
 * fBNg͏ɁuYvƂȂB
 */
public abstract class Size extends Condition {

    private final long value;

    /**
     * Size̐B
     * @param value
     */
    protected Size(long value) {
        super(String.valueOf(value), false);
        this.value = value;
    }

    /* (overridden)
     * @see net.argius.frui.Operation#operate(net.argius.frui.FileInfo)
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        File file = fileInfo.getFile();
        if (file.isDirectory()) {
            return false;
        }
        return isNegative != compare(value, file.length());
    }

    /**
     * t@CTCYrB
     * @param size wTCY
     * @param fileSize t@CTCY
     * @return TCY̊֌W𖞂ꍇ <code>true</code>A
     *         łȂꍇ <code>false</code>
     */
    protected abstract boolean compare(long size, long fileSize);

    /**
     * CX^X擾B
     * @param expression TCYw蕶
     * @return CX^X
     */
    public static Size getInstance(String expression) {
        return parseExpression(expression);
    }

    /**
     * w蕶͂B
     * @param expression w蕶
     * @return CX^X
     */
    private static Size parseExpression(String expression) {
        int firstIndex = 0;
        char firstChar = expression.charAt(0);
        if (!Character.isDigit(firstChar)) {
            ++firstIndex;
        }
        int lastIndex = expression.length();
        char lastChar = expression.charAt(lastIndex - 1);
        int rate;
        if (Character.isDigit(lastChar)) {
            rate = 0;
        } else {
            --lastIndex;
            rate = getRate(lastChar);
        }
        String sizeValue = expression.substring(firstIndex, lastIndex);
        long value;
        if (rate > 0) {
            value = (long)(Double.parseDouble(sizeValue) * Math.pow(1024, rate));
        } else {
            value = Long.parseLong(sizeValue);
        }
        if (firstChar == '+') {
            return new MinLimit(value);
        }
        if (firstChar == '-') {
            return new MaxLimit(value);
        }
        if (firstChar == '=' || Character.isDigit(firstChar)) {
            return new Equal(value);
        }
        throw new IllegalOperationException(IllegalOperationException.EXPRESSION,
                                            expression);
    }

    /**
     * Pʂ̔{ԂB
     * @param lastChar Pʕ
     * @return {
     */
    private static int getRate(char lastChar) {
        switch (lastChar) {
            case 'T':
            case 't':
                return 4;
            case 'G':
            case 'g':
                return 3;
            case 'M':
            case 'm':
                return 2;
            case 'K':
            case 'k':
                return 1;
            default:
                throw new IllegalOperationException(IllegalOperationException.EXPRESSION,
                                                    "unit: " + lastChar);
        }
    }

    /**
     * TCYB
     */
    public static final class Equal extends Size {

        /**
         * Equal̐B
         * @param size TCY
         */
        public Equal(long size) {
            super(size);
        }

        /* (overridden)
         * @see net.argius.frui.operation.Size#compare(long, long)
         */
        protected boolean compare(long size, long fileSize) {
            return fileSize == size;
        }

    }

    /**
     * TCYB 
     */
    public static final class MaxLimit extends Size {

        /**
         * MaxLimit̐B
         * @param size TCY
         */
        public MaxLimit(long size) {
            super(size);
        }

        /* (overridden)
         * @see net.argius.frui.operation.Size#compare(long, long)
         */
        protected boolean compare(long size, long fileSize) {
            return fileSize <= size;
        }

    }

    /**
     * TCYB
     */
    public static final class MinLimit extends Size {

        /**
         * MinLimit̐B
         * @param size TCY
         */
        public MinLimit(long size) {
            super(size);
        }

        /* (overridden)
         * @see net.argius.frui.operation.Size#compare(long, long)
         */
        protected boolean compare(long size, long fileSize) {
            return fileSize >= size;
        }

    }

}