package net.argius.frui.operation;

import java.io.*;
import java.util.*;
import java.util.zip.*;

import net.argius.frui.*;

/**
 * ZIPGg"GREP"B
 * Gg̃XgeLXgt@CɌāA
 * GREP̂悤ɏB
 * PsłvꍇAuYvƂȂA
 * vs͍sɒǉB
 */
public class GrepZip extends Grep {

    /**
     * GrepZip̐B
     * @param patternString
     */
    public GrepZip(String patternString) {
        this(patternString, false);
    }

    /**
     * GrepZip̐B
     * @param patternString 
     * @param isIgnoreCase
     */
    public GrepZip(String patternString, boolean isIgnoreCase) {
        super(patternString, isIgnoreCase);
    }

    /* (overridden)
     * @see net.argius.frui.Operation#operate(net.argius.frui.FileInfo)
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        File file = fileInfo.getFile();
        List lineInfoList = fileInfo.getLineInfoList();
        if (!lineInfoList.isEmpty()) {
            return false;
        }
        ZipFile zipfile = new ZipFile(file);
        try {
            Enumeration e = zipfile.entries();
            for (int i = 1; e.hasMoreElements(); i++) {
                ZipEntry entry = (ZipEntry)e.nextElement();
                String name = entry.getName();
                if (matchPattern(name)) {
                    lineInfoList.add(new LineInfo(i, name));
                }
            }
        } finally {
            zipfile.close();
        }
        return isNegative != (!lineInfoList.isEmpty());
    }

}