package net.argius.frui.operation;

import java.io.*;
import java.util.*;

import net.argius.frui.*;
import net.argius.frui.io.*;
import net.argius.frui.text.*;

/**
 * "GREP"B
 * t@CeLXgf[^Ƃēǂݍ݁A
 * sƂɎw肳ꂽp^[ƈv邩ǂׂB
 * PsłvꍇAuYvƂȂA
 * vs͍sɒǉB
 */
public class Grep extends Condition {

    protected final Pattern pattern;
    protected final boolean detectBinary;
    protected final boolean detectEncoding;

    /**
     * Grep̐B
     * @param patternString p^[
     */
    public Grep(String patternString) {
        this(patternString, false);
    }

    /**
     * Grep̐B
     * @param patternString p^[
     * @param isIgnoreCase 啶𖳎ꍇ <code>true</code>
     */
    public Grep(String patternString, boolean isIgnoreCase) {
        super(patternString, isIgnoreCase);
        pattern = PatternFactory.create(patternString, isIgnoreCase);
        detectBinary = Environment.getBooleanProperty("detect.binary");
        detectEncoding = Environment.getBooleanProperty("detect.encoding");
    }

    /* (overridden)
     * @see net.argius.frui.operation.Operation#operate(net.argius.frui.operation.FileInfo)
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        List lineInfoList = fileInfo.getLineInfoList();
        if (lineInfoList.isEmpty()) {
            File file = fileInfo.getFile();
            if (file.isDirectory()) {
                return false;
            }
            if (detectEncoding && !fileInfo.getEncodingType().isDetected()) {
                fileInfo.setEncodingType(Utilities.detectEncoding(file));
            }
            if (detectBinary && !fileInfo.getEncodingType().isDetected()) {
                if (IOUtilities.isBinary(file)) {
                    return false;
                }
            }
            LineNumberReader reader;
            if (fileInfo.getEncodingType().isDetected()) {
                String encName = fileInfo.getEncodingType().getName();
                reader = new LineNumberReader(new InputStreamReader(new FileInputStream(file),
                                                                    encName));
            } else {
                reader = new LineNumberReader(new FileReader(file));
            }
            try {
                scanLines(fileInfo, reader);
            } finally {
                reader.close();
            }
            return isNegative != (!lineInfoList.isEmpty());
        } else {
            scanLines(lineInfoList);
            return !lineInfoList.isEmpty();
        }
    }

    /**
     * p^[}b`OsB
     * @param line }b`s
     * @return }b`ꍇ <code>true</code>
     * @@@@}b`Ȃꍇ <code>false</code>
     */
    protected boolean matchPattern(String line) {
        return pattern.find(line);
    }

    /**
     * t@Cǂݍōs𑖍B
     * @param fileInfo t@C
     * @param reader sԍ̓Xg[
     * @throws IOException o̓G[ꍇ
     */
    private void scanLines(FileInfo fileInfo, LineNumberReader reader) throws IOException {
        List lineInfoList = fileInfo.getLineInfoList();
        for (String line; (line = reader.readLine()) != null;) {
            if (matchPattern(line)) {
                lineInfoList.add(new LineInfo(reader.getLineNumber(), line));
            }
        }
    }

    /**
     * 擾ς̍s𑖍B
     * @param lineInfoList s񃊃Xg
     */
    private void scanLines(List lineInfoList) {
        LineInfo[] lineInfos = (LineInfo[])lineInfoList.toArray(new LineInfo[lineInfoList.size()]);
        for (int i = 0, n = lineInfos.length; i < n; i++) {
            LineInfo lineInfo = lineInfos[i];
            if (isNegative == matchPattern(lineInfo.getLineString())) {
                lineInfoList.remove(lineInfo);
            }
        }
    }

}