package net.argius.frui.io;

import java.io.*;

/**
 * sێ郊[_B
 * @\ŏɂ邽߁A}[NET|[gȂB
 */
public final class LineReader extends BufferedReader {

    private static final String EMPTY_STRING = "";

    private Reader in;
    private boolean skipLF;
    private int lineNumber;
    private String lineSeparator;
    private CharSequenceFIFO buffer;

    /**
     * LineReader̐B
     * @param in
     */
    public LineReader(Reader in) {
        super(in, 1);
        this.in = in;
        this.lineNumber = 0;
        this.lineSeparator = EMPTY_STRING;
        this.buffer = new CharSequenceFIFO(8192);
    }

    /**
     * Xg[JĂ邱ƂmFB
     * @throws IOException Xg[Ăꍇ
     */
    private void ensureOpen() throws IOException {
        if (in == null) {
            throw new IOException("stream is closed");
        }
    }

    /* (overridden)
     * @see java.io.BufferedReader#close()
     */
    public void close() throws IOException {
        in = null;
        buffer = null;
        super.close();
    }

    /* (overridden)
     * @see java.io.BufferedReader#markSupported()
     */
    public boolean markSupported() {
        return false;
    }

    /* (overridden)
     * @see java.io.Reader#read()
     */
    public int read() throws IOException {
        synchronized (lock) {
            ensureOpen();
            char c;
            if (buffer.length() <= 0) {
                int readChar = in.read();
                if (readChar <= 0) {
                    return -1; // EOF
                }
                c = (char)readChar;
            } else {
                c = buffer.draw(1).charAt(0);
            }
            switch (c) {
                case '\r':
                    skipLF = true;
                    ++lineNumber;
                    lineSeparator += c;
                    break;
                case '\n':
                    if (!skipLF) {
                        ++lineNumber;
                    }
                    skipLF = false;
                    lineSeparator += c;
                    break;
                default:
                    lineSeparator = EMPTY_STRING;
            }
            return c;
        }
    }

    /* (overridden)
     * @see java.io.Reader#read(char[], int, int)
     */
    public int read(char cbuf[], int off, int len) throws IOException {
        synchronized (lock) {
            ensureOpen();
            if (len == 0) {
                return 0;
            }
            int length = len;
            if (buffer.length() <= 0) {
                int readLength = readChars(cbuf, off, len);
                if (readLength <= 0) {
                    return -1; // EOF
                }
                if (readLength < len) {
                    length = readLength;
                }
            }
            CharSequence seq = buffer.draw(length);
            int readLength = seq.length();
            for (int i = 0; i < readLength; i++) {
                char c = seq.charAt(i);
                cbuf[off + i] = c;
                switch (c) {
                    case '\r':
                        skipLF = true;
                        ++lineNumber;
                        lineSeparator += c;
                        break;
                    case '\n':
                        if (!skipLF) {
                            ++lineNumber;
                            skipLF = false;
                        }
                        lineSeparator += c;
                        break;
                    default:
                        lineSeparator = EMPTY_STRING;
                }
            }
            return readLength;
        }
    }

    /* (overridden)
     * @see java.io.BufferedReader#readLine()
     */
    public String readLine() throws IOException {
        synchronized (lock) {
            ensureOpen();
            int position = 0;
            while (true) {
                if (buffer.length() <= position) {
                    if (readChars() <= 0) {
                        break;
                    }
                }
                int lengthLS = 0;
                int indexCR = buffer.indexOf('\r', position);
                int indexLF = buffer.indexOf('\n', position);
                int index;
                if (indexCR >= 0 && indexLF >= 0) {
                    ++lengthLS;
                    if (indexCR < indexLF) {
                        if (indexCR + 1 == indexLF) {
                            index = indexLF;
                            ++lengthLS;
                        } else {
                            index = indexCR;
                        }
                    } else {
                        index = indexLF;
                    }
                } else if (indexCR >= 0) {
                    index = indexCR;
                    ++lengthLS;
                } else if (indexLF >= 0) {
                    index = indexLF;
                    ++lengthLS;
                } else {
                    position = buffer.length();
                    continue;
                }
                CharSequence seq = buffer.draw(index + 1);
                int lineLength = seq.length();
                if (lineLength <= 0) {
                    break;
                }
                int p = lineLength - lengthLS;
                skipLF = false;
                ++lineNumber;
                lineSeparator = seq.toString().substring(p);
                return seq.subSequence(0, p).toString();
            }
            if (buffer.length() > 0) {
                skipLF = false;
                ++lineNumber;
                lineSeparator = EMPTY_STRING;
                return buffer.draw().toString();
            } else {
                return null; // EOF
            }
        }
    }

    /**
     * ʓǂݍށB
     * @return ǂݍ񂾕
     * @throws IOException o̓G[ꍇ
     */
    private int readChars() throws IOException {
        synchronized (lock) {
            ensureOpen();
            char[] chars = new char[1024];
            int length = in.read(chars);
            if (length > 0) {
                buffer.add(chars, 0, length);
            }
            return length;
        }
    }

    /**
     * ʓǂݍށB
     * @param buf obt@
     * @param off ItZbg
     * @param len 
     * @return ǂݍ񂾕
     * @throws IOException o̓G[ꍇ
     */
    private int readChars(char[] buf, int off, int len) throws IOException {
        synchronized (lock) {
            ensureOpen();
            int length = in.read(buf, off, len);
            if (length > 0) {
                buffer.add(buf, off, length);
            }
            return length;
        }
    }

    /**
     * sԍ̎擾B
     * @return sԍ
     */
    public int getLineNumber() {
        return lineNumber;
    }

    /**
     * LineSeparator̎擾B
     * @return LineSeparator
     */
    public String getLineSeparator() {
        return lineSeparator;
    }

}