package net.argius.frui.operation;

import java.io.*;

import net.argius.frui.*;

/**
 * l[B
 * ړɋ߂Aul[邱Ɓvɏd_uƂȂĂB
 * 啶ɂĒup^[ʂB
 */
public final class Rename implements Operation {

    private String parameterString;
    private String patternUpperCase;
    private String patternLowerCase;
    private String patternCapitalLetter;
    private String replaceUpperCase;
    private String replaceLowerCase;
    private String replaceCapitalLetter;

    /**
     * Rename̐B
     * @param patternString vp^[
     * @param replaceString up^[
     */
    public Rename(String patternString, String replaceString) {
        Utilities.checkModifiable();
        if (!Environment.getBooleanProperty("replace")) {
            throw new IllegalOperationException(IllegalOperationException.PROPERTY,
                                                Messages.getString("error.unable.modify"));
        }
        parameterString = patternString + "/" + replaceString;
        patternUpperCase = patternString.toUpperCase();
        patternLowerCase = patternString.toLowerCase();
        patternCapitalLetter = toCapitalLetter(patternString);
        replaceUpperCase = replaceString.toUpperCase();
        replaceLowerCase = replaceString.toLowerCase();
        replaceCapitalLetter = toCapitalLetter(replaceString);
    }

    /**
     * 擪啶AȊOɂB
     * @param string 
     * @return ҏWꂽ
     */
    private static String toCapitalLetter(String string) {
        if (string.length() == 0) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    /* (overridden)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Utilities.getSimpleClassName(getClass()));
        buffer.append("(/");
        buffer.append(parameterString);
        buffer.append("/)");
        return buffer.toString();
    }

    /* (overridden)
     * @see net.argius.frui.operation.Operation#operate(net.argius.frui.operation.FileInfo)
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        File file = fileInfo.getFile();
        if (file.isDirectory()) {
            return false;
        }
        String path = file.getPath();
        if (path.indexOf(patternUpperCase) >= 0
            || path.indexOf(patternLowerCase) >= 0
            || path.indexOf(patternCapitalLetter) >= 0) {
            path = Utilities.replaceAll(patternUpperCase,
                                        path,
                                        replaceUpperCase);
            path = Utilities.replaceAll(patternLowerCase,
                                        path,
                                        replaceLowerCase);
            path = Utilities.replaceAll(patternCapitalLetter,
                                        path,
                                        replaceCapitalLetter);
            File newFile = new File(path);
            if (!newFile.exists()) {
                File parent = newFile.getParentFile();
                if (parent != null && !parent.exists()) {
                    if (!parent.mkdirs()) {
                        throw new IOException("can't create : " + parent);
                    }
                }
                replaceContent(file, newFile);
                fileInfo.setFile(newFile);
            }
            return true;
        }
        return false;
    }

    /**
     * t@C̃l[sB
     * @param file ̃t@C
     * @param newFile ut@C
     * @throws IOException o̓G[ꍇ
     */
    private void replaceContent(File file, File newFile) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(newFile));
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                for (String line; (line = bufferedReader.readLine()) != null;) {
                    line = Utilities.replaceAll(patternUpperCase,
                                                line,
                                                replaceUpperCase);
                    line = Utilities.replaceAll(patternLowerCase,
                                                line,
                                                replaceLowerCase);
                    line = Utilities.replaceAll(patternCapitalLetter,
                                                line,
                                                replaceCapitalLetter);
                    out.println(line);
                }
            } finally {
                bufferedReader.close();
            }
        } finally {
            out.close();
        }
    }

}