/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.operation;

import java.io.File;
import java.io.IOException;
import net.argius.frui.Environment;
import net.argius.frui.IllegalOperationException;
import net.argius.frui.Messages;
import net.argius.frui.io.EncodingType;
import net.argius.frui.io.EncodingTypeDetection;
import net.argius.frui.text.Pattern;
import net.argius.frui.text.PatternFactory;

final class Utilities {
    private static int number = 0;

    private Utilities() {
    }

    static String replaceAll(String string, String string2, String string3) {
        return PatternFactory.create(string).replaceAll(string2, string3);
    }

    static String replaceAll(Pattern pattern, String string, String string2) {
        return pattern.replaceAll(string, string2);
    }

    static String getSimpleClassName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(n + 1) : string;
    }

    static void checkModifiable() {
        if (!Environment.getBooleanProperty("modify")) {
            throw new IllegalOperationException(0, Messages.getString("error.unable.modify"));
        }
    }

    static String getFileSizeFormatString() {
        return Environment.getProperty("format.filesize");
    }

    static String getDateFormatString() {
        String string = Environment.getProperty("format.date");
        if (string.length() > 0) {
            return string;
        }
        return "yyyy/MM/dd HH:mm:ss";
    }

    static EncodingType detectEncoding(File file) throws IOException {
        return EncodingTypeDetection.getInstance().detect(file);
    }

    static File createTemporaryDirectory() {
        File file = new File(System.getProperty("java.io.tmpdir"), "Frui");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.currentTimeMillis());
        stringBuffer.append('_');
        stringBuffer.append(++number);
        return new File(file, stringBuffer.toString());
    }
}

