/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.operation;

import java.io.File;
import java.io.IOException;
import net.argius.frui.FileInfo;
import net.argius.frui.Operation;
import net.argius.frui.io.IOUtilities;
import net.argius.frui.operation.Utilities;
import net.argius.frui.text.Pattern;
import net.argius.frui.text.PatternFactory;

public class Move
implements Operation {
    private final Pattern pattern;
    private final String patternString;
    private final String replaceString;
    private final File backupDirectory;
    private final boolean isIgnoreCase;

    public Move(String string, String string2) {
        this(string, string2, false);
    }

    public Move(String string, String string2, boolean bl) {
        Utilities.checkModifiable();
        this.pattern = PatternFactory.create(string, bl);
        this.patternString = string;
        this.replaceString = string2;
        this.backupDirectory = Utilities.createTemporaryDirectory();
        this.isIgnoreCase = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isIgnoreCase) {
            stringBuffer.append('i');
        }
        stringBuffer.append(Utilities.getSimpleClassName(this.getClass()));
        stringBuffer.append('(');
        stringBuffer.append(this.patternString);
        stringBuffer.append(',');
        stringBuffer.append(this.replaceString);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean operate(FileInfo fileInfo) throws IOException {
        File file = fileInfo.getFile();
        if (file.isDirectory()) {
            return false;
        }
        String string = file.toString();
        if (this.pattern.find(string)) {
            String string2 = Utilities.replaceAll(this.pattern, string, this.replaceString);
            File file2 = new File(string2);
            IOUtilities.copy(file, new File(this.backupDirectory, file.getPath()));
            if (this.doMove(file, file2)) {
                fileInfo.setFile(file2);
            }
            return true;
        }
        return false;
    }

    protected boolean doMove(File file, File file2) throws IOException {
        return IOUtilities.move(file, file2, false);
    }
}

