/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import net.argius.frui.Environment;
import net.argius.frui.text.Pattern;
import net.argius.frui.text.PatternFactory;
import net.argius.frui.text.StringMatcher;

public final class FindFileFilter
implements FileFilter {
    private final Pattern pattern;
    private final boolean separatorReplace;
    private char oldSeparator;
    private char newSeparator;

    public FindFileFilter(String string) {
        this(string, false);
    }

    public FindFileFilter(String string, boolean bl) {
        Object object;
        if (string.startsWith(".")) {
            object = new StringMatcher(",");
            this.pattern = new SuffixMatcher(((StringMatcher)object).split(string.substring(1)));
        } else {
            this.pattern = PatternFactory.create(string, bl);
        }
        object = Environment.getProperty("path.separator");
        if (((String)object).length() == 1 && !((String)object).equals(File.separator)) {
            this.oldSeparator = File.separatorChar;
            this.newSeparator = ((String)object).charAt(0);
            this.separatorReplace = true;
        } else {
            this.separatorReplace = false;
        }
    }

    public boolean accept(File file) {
        String string = file.getPath();
        if (this.separatorReplace) {
            string = string.replace(this.oldSeparator, this.newSeparator);
        }
        return this.pattern.find(string);
    }

    public String toString() {
        return this.pattern.pattern();
    }

    private static final class SuffixMatcher
    implements Pattern {
        private final String[] suffixes;

        public SuffixMatcher(String[] stringArray) {
            this.suffixes = (String[])stringArray.clone();
        }

        public boolean find(String string) {
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                String string2 = string.substring(n + 1);
                for (int i = 0; i < this.suffixes.length; ++i) {
                    if (!string2.equalsIgnoreCase(this.suffixes[i])) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean matches(String string) {
            return this.find(string);
        }

        public String pattern() {
            return Arrays.asList(this.suffixes).toString();
        }

        public String replaceAll(String string, String string2) {
            return this.replaceFirst(string, string2);
        }

        public String replaceFirst(String string, String string2) {
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                String string3 = string.substring(n);
                for (int i = 0; i < this.suffixes.length; ++i) {
                    if (!string3.equalsIgnoreCase(this.suffixes[i])) continue;
                    return string.substring(0, n) + string2;
                }
            }
            return string;
        }

        public String[] split(String string) {
            return new String[]{string};
        }
    }
}

