package net.argius.frui.text;

/**
 * p^[vNXB
 * <code>java.util.regex</code>pbP[Wւ̈ϏB
 */
final class PatternMatcher implements Pattern {

    private final String expression;
    private final java.util.regex.Pattern pattern;

    /**
     * PatternMatcher̐B
     * @param expression ̃p^[\
     * @param pattern p^[
     * @param flags p^[tO
     */
    public PatternMatcher(String expression, String pattern, int flags) {
        this.expression = expression;
        this.pattern = java.util.regex.Pattern.compile(pattern, flags);
    }

    /* (overridden)
     * @see net.argius.frui.text.Pattern#matches(java.lang.String)
     */
    public boolean matches(String input) {
        return pattern.matcher(input).matches();
    }

    /* (overridden)
     * @see net.argius.frui.text.Pattern#find(java.lang.String)
     */
    public boolean find(String input) {
        return pattern.matcher(input).find();
    }

    /* (overridden)
     * @see net.argius.frui.text.Pattern#replaceAll(java.lang.String, java.lang.String)
     */
    public String replaceAll(String input, String replacement) {
        return pattern.matcher(input).replaceAll(replacement);
    }

    /* (overridden)
     * @see net.argius.frui.text.Pattern#replaceFirst(java.lang.String, java.lang.String)
     */
    public String replaceFirst(String input, String replacement) {
        return pattern.matcher(input).replaceFirst(replacement);
    }

    /* (overridden)
     * @see net.argius.frui.text.Pattern#split()
     */
    public String[] split(String input) {
        return pattern.split(input);
    }

    /* (overridden)
     * @see net.argius.frui.text.Pattern#pattern()
     */
    public String pattern() {
        return expression;
    }

}