package net.argius.frui.operation;

import java.io.*;

import net.argius.frui.*;
import net.argius.frui.io.*;
import net.argius.frui.text.*;

/**
 * ftHgOp^[B
 */
public final class Ignore extends Condition {

    private final FindFileFilter[] filters;

    /**
     * Ignore̐B
     */
    public Ignore() {
        this(Environment.getProperty("ignore"));
    }

    /**
     * Ignore̐B
     * @param prop vpeB
     */
    public Ignore(String prop) {
        super(prop, false);
        if (prop.length() > 0) {
            String[] patterns = PatternFactory.create(" ").split(prop);
            filters = new FindFileFilter[patterns.length];
            for (int i = 0; i < patterns.length; i++) {
                filters[i] = new FindFileFilter(patterns[i]);
            }
        } else {
            filters = new FindFileFilter[0];
        }
    }

    /**
     * ftHgO@\Lǂ𒲍B
     * @return ftHgO@\LȂ<code>true</code>AłȂ<code>false</code>
     */
    public boolean isEnabled() {
        return filters.length > 0;
    }

    /* (overridden)
     * @see net.argius.frui.Operation#operate(net.argius.frui.FileInfo)
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        File file = fileInfo.getFile();
        for (int i = 0; i < filters.length; i++) {
            FindFileFilter filter = filters[i];
            if (isNegative != filter.accept(file)) {
                return false;
            }
        }
        return true;
    }

}