package net.argius.frui;

import java.io.*;
import java.util.*;
import java.util.Map.*;

import net.argius.frui.operation.*;

/**
 * Verbose[hB
 */
public final class VerboseMode {

    /**
     * VerboseMode̐B
     */
    private VerboseMode() {
        // empty
    }

    /**
     * AvP[VNB
     * @param application Application
     * @param operationList OperatioñXg
     */
    public static void invoke(Application application, List operationList) {
        Operation[] operations = (Operation[])operationList.toArray(new Operation[operationList.size()]);
        invoke(application, operations);
    }

    /**
     * AvP[VNB
     * @param application Application
     * @param operations Operation̔z
     */
    public static void invoke(Application application, Operation[] operations) {
        Print print = new PrintInfo();
        List list = new ArrayList();
        for (int i = 0; i < operations.length; i++) {
            Operation operation = operations[i];
            if (operation instanceof Print) {
                print = (Print)operation;
            } else {
                list.add(operation);
            }
        }
        Operation[] ops = (Operation[])list.toArray(new Operation[list.size()]);
        printOptions(application, ops, print);
        long startTime = System.currentTimeMillis();
        application.invoke(ops, print);
        long timeRequired = System.currentTimeMillis() - startTime;
        String mTime = "[TIME]   " + (timeRequired / 1000f) + " seconds";
        print.printMessage(mTime);
        String mResult = "[RESULT] found "
                         + application.getFoundCount()
                         + " files / "
                         + application.getScannedCount();
        int missingFileCount = application.getMissingFileCount();
        if (missingFileCount > 0) {
            mResult += " (" + missingFileCount + " missing files)";
        }
        print.printMessage(mResult);
    }

    /**
     * IvVo͂B
     * @param application Application
     * @param operations Operation̔z
     * @param print Print
     */
    private static void printOptions(Application application,
                                     Operation[] operations,
                                     Print print) {
        Writer buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        Map modeMap = new HashMap();
        modeMap.put("directory", Arrays.asList(application.getDirectories()));
        modeMap.put("verbose", Boolean.valueOf(application.isVerbose()));
        int minDepth = application.getMinDepth();
        int maxDepth = application.getMaxDepth();
        if (minDepth != 0 || maxDepth != Integer.MAX_VALUE) {
            String s = "";
            if (minDepth != 0) {
                s += minDepth;
            }
            s += "..";
            if (maxDepth != Integer.MAX_VALUE) {
                s += maxDepth;
            }
            modeMap.put("depthRange", s);
        }
        int limit = application.getLimit();
        if (limit != Integer.MAX_VALUE) {
            modeMap.put("limit", new Integer(limit));
        }
        out.print("[MODE]  ");
        for (Iterator it = modeMap.entrySet().iterator(); it.hasNext();) {
            Entry entry = (Entry)it.next();
            out.print(' ');
            out.print(entry.getKey());
            out.print('=');
            out.print(entry.getValue());
        }
        out.println();
        out.print("[PROP]  ");
        final String prefix = "net.argius.frui.";
        for (Iterator it = System.getProperties().entrySet().iterator(); it.hasNext();) {
            Entry entry = (Entry)it.next();
            String key = (String)entry.getKey();
            if (key.startsWith(prefix)) {
                out.print(' ');
                out.print(key.substring(prefix.length()));
                out.print('=');
                out.print(entry.getValue());
            }
        }
        out.println();
        out.print("[FILTER] ");
        boolean first = true;
        for (int i = 0, n = operations.length; i < n; i++) {
            Object o = operations[i];
            if (first) {
                first = false;
            } else {
                out.print(" & ");
            }
            out.print(o);
        }
        out.print(" & ");
        out.print(print);
        out.flush();
        print.printMessage(buffer.toString());
    }

}
