package net.argius.frui.operation;

import java.io.*;

import net.argius.frui.*;
import net.argius.frui.io.*;

/**
 * w肵fBNgփRs[鏈(SendTo)B
 */
public final class Send implements Operation {

    private File directory;

    /**
     * Send̐B
     * @param path fBNg̃pX
     */
    public Send(String path) {
        directory = new File(path);
        if (!directory.isDirectory()) {
            String message = Messages.getString("error.nonexistent.directory")
                             + Constants.MESSAGE_SEPARATOR
                             + directory;
            throw new IllegalOperationException(IllegalOperationException.IO,
                                                message);
        }
    }

    /* (overridden)
     * @see net.argius.frui.Operation#operate(net.argius.frui.FileInfo)
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        File file = fileInfo.getFile();
        if (!file.isDirectory() && !file.isAbsolute()) {
            File newPath = new File(directory, file.getPath());
            File newFile = newPath.getCanonicalFile();
            IOUtilities.copy(file, newFile, true);
            fileInfo.setFile(newFile);
            return true;
        }
        return false;
    }

}