package net.argius.frui.text;

import org.apache.regexp.*;

/**
 * K\p^[̃t@NgB
 * @see java.util.regex.Pattern
 */
public final class PatternFactory {

    private static final String PATTERN1 = "^/([^/].*)/([A-Za-z]*)$";

    /**
     * PatternFactory̐B
     */
    private PatternFactory() {
        // empty
    }
    
    /**
     * K\p^[𐶐B
     * @param expression p^[\
     * @return K\p^[
     * @throws PatternException p^[񂪐K\ƂĐȂꍇ
     */
    public static Pattern create(String expression) throws PatternException {
        return create(expression, false);
    }

    /**
     * K\p^[𐶐B
     * @param expression p^[\
     * @param isIgnoreCase 
     * @return K\p^[
     * @throws PatternException p^[񂪐K\ƂĐȂꍇ
     */
    public static Pattern create(String expression, boolean isIgnoreCase) throws PatternException {
        String pattern;
        int flags = 0;
        if (isIgnoreCase) {
            flags |= RE.MATCH_CASEINDEPENDENT;
        }
        RE re = new RE(PATTERN1);
        if (re.match(expression)) {
            pattern = re.getParen(1);
            String flagsString = re.getParen(2);
            if (flagsString != null) {
                if (flagsString.indexOf('i') >= 0) {
                    flags |= RE.MATCH_CASEINDEPENDENT;
                }
                if (flagsString.indexOf('m') >= 0) {
                    flags |= RE.MATCH_MULTILINE;
                }
            }
            return new PatternMatcher(expression, pattern, flags);
        } else {
            return new StringMatcher(expression, isIgnoreCase);
        }
    }

}