/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.operation;

import java.io.File;
import java.io.IOException;
import net.argius.frui.FileInfo;
import net.argius.frui.IllegalOperationException;
import net.argius.frui.operation.Condition;

public abstract class Size
extends Condition {
    private final long value;

    protected Size(long l) {
        super(String.valueOf(l), false);
        this.value = l;
    }

    public boolean operate(FileInfo fileInfo) throws IOException {
        File file = fileInfo.getFile();
        if (file.isDirectory()) {
            return false;
        }
        return this.isNegative != this.compare(this.value, file.length());
    }

    protected abstract boolean compare(long var1, long var3);

    public static Size getInstance(String string) {
        return Size.parseExpression(string);
    }

    private static Size parseExpression(String string) {
        int n;
        int n2;
        char c;
        int n3 = 0;
        char c2 = string.charAt(0);
        if (!Character.isDigit(c2)) {
            ++n3;
        }
        if (Character.isDigit(c = string.charAt((n2 = string.length()) - 1))) {
            n = 0;
        } else {
            --n2;
            n = Size.getRate(c);
        }
        String string2 = string.substring(n3, n2);
        long l = n > 0 ? (long)(Double.parseDouble(string2) * Math.pow(1024.0, n)) : Long.parseLong(string2);
        if (c2 == '+') {
            return new MinLimit(l);
        }
        if (c2 == '-') {
            return new MaxLimit(l);
        }
        if (c2 == '=' || Character.isDigit(c2)) {
            return new Equal(l);
        }
        throw new IllegalOperationException(1, string);
    }

    private static int getRate(char c) {
        switch (c) {
            case 'T': 
            case 't': {
                return 4;
            }
            case 'G': 
            case 'g': {
                return 3;
            }
            case 'M': 
            case 'm': {
                return 2;
            }
            case 'K': 
            case 'k': {
                return 1;
            }
        }
        throw new IllegalOperationException(1, "unit: " + c);
    }

    public static final class MinLimit
    extends Size {
        public MinLimit(long l) {
            super(l);
        }

        protected boolean compare(long l, long l2) {
            return l2 >= l;
        }
    }

    public static final class MaxLimit
    extends Size {
        public MaxLimit(long l) {
            super(l);
        }

        protected boolean compare(long l, long l2) {
            return l2 <= l;
        }
    }

    public static final class Equal
    extends Size {
        public Equal(long l) {
            super(l);
        }

        protected boolean compare(long l, long l2) {
            return l2 == l;
        }
    }
}

