/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.operation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import net.argius.frui.Environment;
import net.argius.frui.FileInfo;
import net.argius.frui.IllegalOperationException;
import net.argius.frui.LineInfo;
import net.argius.frui.Messages;
import net.argius.frui.io.IOUtilities;
import net.argius.frui.io.LineReader;
import net.argius.frui.operation.Grep;
import net.argius.frui.operation.Utilities;
import net.argius.frui.text.Pattern;
import net.argius.frui.text.PatternFactory;

public final class Replace
extends Grep {
    private final String replaceString;
    private final File backupDirectory;
    private final boolean isIgnoreCase;
    static /* synthetic */ Class class$net$argius$frui$operation$Replace;

    public Replace(String string, String string2) {
        this(string, string2, false);
    }

    public Replace(String string, String string2, boolean bl) {
        super(string, bl);
        Utilities.checkModifiable();
        if (!Environment.getBooleanProperty("replace")) {
            throw new IllegalOperationException(0, Messages.getString("error.unable.modify"));
        }
        this.replaceString = string2;
        this.backupDirectory = Utilities.createTemporaryDirectory();
        this.isIgnoreCase = bl;
    }

    public boolean operate(FileInfo fileInfo) throws IOException {
        super.operate(fileInfo);
        List list = fileInfo.getLineInfoList();
        if (!list.isEmpty()) {
            this.replace(fileInfo);
        }
        return this.isNegative != !list.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replace(FileInfo fileInfo) throws IOException {
        File file;
        File file2;
        block13: {
            file2 = fileInfo.getFile();
            this.backupFile(file2);
            file = File.createTempFile("Frui.", ".tmp");
            file.deleteOnExit();
            if (this.detectEncoding && fileInfo.getEncodingType().isDetected()) {
                String string = fileInfo.getEncodingType().getName();
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string));
                try {
                    LineReader lineReader = new LineReader(new InputStreamReader((InputStream)new FileInputStream(file2), string));
                    try {
                        this.replaceLines(fileInfo, lineReader, bufferedWriter);
                        break block13;
                    }
                    finally {
                        lineReader.close();
                    }
                }
                finally {
                    bufferedWriter.close();
                }
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            try {
                LineReader lineReader = new LineReader(new FileReader(file2));
                try {
                    this.replaceLines(fileInfo, lineReader, bufferedWriter);
                }
                finally {
                    lineReader.close();
                }
            }
            finally {
                bufferedWriter.close();
            }
        }
        IOUtilities.copy(file, file2, true);
    }

    private void backupFile(File file) throws IOException {
        if (!this.backupDirectory.exists()) {
            this.backupDirectory.mkdirs();
        }
        File file2 = new File(this.backupDirectory, file.getPath());
        try {
            IOUtilities.copy(file, file2.getCanonicalFile());
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("backup error (" + file2 + ')');
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    private void replaceLines(FileInfo fileInfo, LineReader lineReader, BufferedWriter bufferedWriter) throws IOException {
        String string;
        List list = fileInfo.getLineInfoList();
        int n = 0;
        int n2 = 0;
        int n3 = list.size();
        while ((string = lineReader.readLine()) != null) {
            int n4 = lineReader.getLineNumber();
            if (n < n4 && n2 < n3) {
                LineInfo lineInfo = (LineInfo)list.get(n2);
                n = lineInfo.getLineNumber();
            }
            if (n == n4) {
                string = Utilities.replaceAll(this.pattern, string, this.replaceString);
                list.set(n2++, new LineInfo(n4, string));
            }
            bufferedWriter.write(string);
            bufferedWriter.write(lineReader.getLineSeparator());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isIgnoreCase) {
            stringBuffer.append('i');
        }
        stringBuffer.append(Utilities.getSimpleClassName(class$net$argius$frui$operation$Replace == null ? (class$net$argius$frui$operation$Replace = Replace.class$("net.argius.frui.operation.Replace")) : class$net$argius$frui$operation$Replace));
        stringBuffer.append('(');
        String string = this.pattern.pattern();
        if (string.startsWith("/")) {
            Pattern pattern = PatternFactory.create("/\\/(.*)\\/(i?)/");
            String string2 = "s/$1/" + this.replaceString + "/$2";
            stringBuffer.append(pattern.replaceFirst(string, string2));
        } else {
            stringBuffer.append(string);
            stringBuffer.append(',');
            stringBuffer.append(this.replaceString);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

