/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.operation;

import java.io.File;
import java.io.IOException;
import net.argius.frui.Environment;
import net.argius.frui.FileInfo;
import net.argius.frui.io.FindFileFilter;
import net.argius.frui.operation.Condition;
import net.argius.frui.text.PatternFactory;

public final class Ignore
extends Condition {
    private final FindFileFilter[] filters;

    public Ignore() {
        this(Environment.getProperty("ignore"));
    }

    public Ignore(String string) {
        super(string, false);
        if (string.length() > 0) {
            String[] stringArray = PatternFactory.create(" ").split(string);
            this.filters = new FindFileFilter[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.filters[i] = new FindFileFilter(stringArray[i]);
            }
        } else {
            this.filters = new FindFileFilter[0];
        }
    }

    public boolean isEnabled() {
        return this.filters.length > 0;
    }

    public boolean operate(FileInfo fileInfo) throws IOException {
        File file = fileInfo.getFile();
        for (int i = 0; i < this.filters.length; ++i) {
            FindFileFilter findFileFilter = this.filters[i];
            if (this.isNegative == findFileFilter.accept(file)) continue;
            return false;
        }
        return true;
    }
}

