package slotmachine.model;

/*
 * VK쐬 : 2005/05/08
 */

/**
 * Xbg}V̊łB
 */
public final class BasicSlotMachine implements SlotMachine {

    private Reel reelLeft;
    private Reel reelCenter;
    private Reel reelRight;

    /**
     * BasicSlotMachine𐶐܂B
     * @param reelLeft
     * @param reelCenter
     * @param reelRight
     */
    public BasicSlotMachine(Reel reelLeft, Reel reelCenter, Reel reelRight) {

        this.reelLeft = reelLeft;
        this.reelCenter = reelCenter;
        this.reelRight = reelRight;

    }

    /* (override)
     * @see slotmachine.model.SlotMachine#getReels()
     */
    public Reel[] getReels() {

        return new Reel[]{reelLeft, reelCenter, reelRight};

    }

    /* (override)
     * @see slotmachine.model.SlotMachineController#requestStart()
     */
    public void requestStart() {

        reelLeft.requestStart();
        reelCenter.requestStart();
        reelRight.requestStart();

    }

    /* (override)
     * @see slotmachine.model.SlotMachineController#requestStop()
     */
    public void requestStop() {

        reelLeft.requestStop();
        reelCenter.requestStop();
        reelRight.requestStop();

    }

    /* (override)
     * @see slotmachine.model.SlotMachineController#stoppedAll()
     */
    public boolean stoppedAll() {

        return reelLeft.isStop() && reelCenter.isStop() && reelRight.isStop();

    }

    /* (override)
     * @see slotmachine.model.SlotMachineController#getTargetList()
     */
    public ReelElementGrid getReelElements() {

        ReelElement[] targetLeft = new ReelElement[]{reelLeft.getElement(ReelPosition.UPPER),
                                                     reelLeft.getElement(ReelPosition.MIDDLE),
                                                     reelLeft.getElement(ReelPosition.LOWER),};

        ReelElement[] targetCenter = new ReelElement[]{reelCenter.getElement(ReelPosition.UPPER),
                                                       reelCenter.getElement(ReelPosition.MIDDLE),
                                                       reelCenter.getElement(ReelPosition.LOWER),};

        ReelElement[] targetRight = new ReelElement[]{reelRight.getElement(ReelPosition.UPPER),
                                                      reelRight.getElement(ReelPosition.MIDDLE),
                                                      reelRight.getElement(ReelPosition.LOWER),};

        return new ReelElementGrid(new ReelElement[][]{targetLeft, targetCenter, targetRight});

    }

}