package slotmachine.graphic;

import java.util.Timer;
import java.util.TimerTask;

/*
 * VK쐬 : 2005/05/10
 */

/**
 * [̒~̌ʂ\^C}[^XNłB
 */
public class ReelStopEffectTask extends TimerTask {

    private static final int DEGREE360 = 360;

    private GraphicReel reel;
    private Timer timer;
    private int frameNumber;
    private double fixedDegree;
    private boolean motionFinished;

    /**
     * ReelStopEffectTask𐶐܂B
     * @param reel Ώ
     */
    public ReelStopEffectTask(GraphicReel reel) {

        super();
        this.reel = reel;

        timer = new Timer();
        timer.scheduleAtFixedRate(this, 0, 5);

        fixedDegree = reel.getDegree();

    }

    /* (override)
     * @see java.lang.Runnable#run()
     */
    public void run() {

        if (motionFinished) {
            timer.cancel();
        } else {
            double adjust = calculateAttenuatingSineWave(++frameNumber / 2 + 0.5);
            reel.setDegree(fixedDegree + adjust * 256);
            if (frameNumber > 100) {
                reel.forceStop();
                reel.setDegree(fixedDegree);
                motionFinished = true;
            }
        }

    }

    /**
     * 鐳giTCgjZo܂B
     * [~鎞̃ol̓[Iɕ\Ă܂B
     * @param x x̒l
     * @return ̒l (-1 < y < 1)
     */
    private double calculateAttenuatingSineWave(double x) {

        // Sin[x] * (1 - ( (x+2) / (x+6) )) ^ 2 * 2
        x *= 47.2;
        double degree = (x < 0 ? DEGREE360 + x % DEGREE360 : x % DEGREE360);
        double sin = Math.sin(Math.toRadians(degree));
        double y = sin * Math.pow((1 - ((x + 2) / (x + 6))), 2);
        return y * 0xFF;

    }

}