package slotmachine.graphic;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Random;
import java.util.Timer;

import javax.swing.JLayeredPane;
import javax.swing.JPanel;

import slotmachine.GraphicView;
import slotmachine.model.BasicSlotMachine;
import slotmachine.model.Reel;
import slotmachine.model.ReelElementGrid;
import slotmachine.model.SlotMachine;

/*
 * VK쐬 : 2005/05/08
 */

/**
 * fthpɎꂽXbg}VłB
 */
public class GraphicSlotMachine extends JPanel implements SlotMachine {

    private static final int WIDTH = 400;
    private static final int HEIGHT = 400;
    private static final Font font = new Font("Monospaced", Font.BOLD, 24);

    private static Random random = new Random(System.currentTimeMillis());

    private CoinCounter coinCounter;
    private FrontPanel frontPanel;
    private GraphicReel reelLeft;
    private GraphicReel reelCenter;
    private GraphicReel reelRight;
    private BasicSlotMachine base;
    private Timer timer;
    private Runnable runnable;
    private int coins;

    /**
     * GraphicSlotMachine𐶐܂B
     * @param runnable Q[is^XN
     */
    public GraphicSlotMachine(Runnable runnable) {

        this.runnable = runnable;

        timer = new Timer();

        reelLeft = new GraphicReel(new GraphicReelElement[]{GraphicReelElement.BELL,
                                                            GraphicReelElement.PLUM,
                                                            GraphicReelElement.CHERRY,
                                                            GraphicReelElement.BELL,
                                                            GraphicReelElement.CHERRY,
                                                            GraphicReelElement.PLUM,
                                                            GraphicReelElement.CHERRY,
                                                            GraphicReelElement.DOLLAR,
                                                            GraphicReelElement.PLUM,
                                                            GraphicReelElement.CHERRY,
                                                            GraphicReelElement.PLUM,
                                                            GraphicReelElement.BELL,
                                                            GraphicReelElement.PLUM,
                                                            GraphicReelElement.CHERRY,
                                                            GraphicReelElement.PLUM,
                                                            GraphicReelElement.BAR,
                                                            GraphicReelElement.CHERRY,
                                                            GraphicReelElement.BELL,
                                                            GraphicReelElement.PLUM,
                                                            GraphicReelElement.BAR,
                                                            GraphicReelElement.SEVEN});
        reelCenter = new GraphicReel(new GraphicReelElement[]{GraphicReelElement.SEVEN,
                                                              GraphicReelElement.BAR,
                                                              GraphicReelElement.DOLLAR,
                                                              GraphicReelElement.BELL,
                                                              GraphicReelElement.CHERRY,
                                                              GraphicReelElement.PLUM,
                                                              GraphicReelElement.PLUM,
                                                              GraphicReelElement.CHERRY,
                                                              GraphicReelElement.PLUM,
                                                              GraphicReelElement.BELL,
                                                              GraphicReelElement.PLUM,
                                                              GraphicReelElement.BELL,
                                                              GraphicReelElement.DOLLAR,
                                                              GraphicReelElement.PLUM,
                                                              GraphicReelElement.BELL,
                                                              GraphicReelElement.PLUM,
                                                              GraphicReelElement.CHERRY,
                                                              GraphicReelElement.DOLLAR,
                                                              GraphicReelElement.PLUM,
                                                              GraphicReelElement.CHERRY,
                                                              GraphicReelElement.PLUM});
        reelRight = new GraphicReel(new GraphicReelElement[]{GraphicReelElement.PLUM,
                                                             GraphicReelElement.CHERRY,
                                                             GraphicReelElement.DOLLAR,
                                                             GraphicReelElement.PLUM,
                                                             GraphicReelElement.BELL,
                                                             GraphicReelElement.BAR,
                                                             GraphicReelElement.PLUM,
                                                             GraphicReelElement.BELL,
                                                             GraphicReelElement.CHERRY,
                                                             GraphicReelElement.PLUM,
                                                             GraphicReelElement.DOLLAR,
                                                             GraphicReelElement.SEVEN,
                                                             GraphicReelElement.CHERRY,
                                                             GraphicReelElement.PLUM,
                                                             GraphicReelElement.BELL,
                                                             GraphicReelElement.BAR,
                                                             GraphicReelElement.DOLLAR,
                                                             GraphicReelElement.PLUM,
                                                             GraphicReelElement.DOLLAR,
                                                             GraphicReelElement.CHERRY,
                                                             GraphicReelElement.PLUM});

        // {̃pl
        setOpaque(false);
        setLayout(null);

        // [y
        JPanel reelBase = new JPanel(null);
        reelBase.setBackground(new Color(0x400000));
        reelBase.setOpaque(true);
        reelBase.add(reelLeft);
        reelBase.add(reelCenter);
        reelBase.add(reelRight);
        reelLeft.setBounds(10, 10, GraphicReel.WIDTH, GraphicReel.HEIGHT);
        reelCenter.setBounds(110, 10, GraphicReel.WIDTH, GraphicReel.HEIGHT);
        reelRight.setBounds(210, 10, GraphicReel.WIDTH, GraphicReel.HEIGHT);

        // tgpl
        frontPanel = new FrontPanel();

        // X^[go[
        StartLever startLever = new StartLever(this);

        // RCJE^
        coinCounter = new CoinCounter();

        // CAEg
        JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.setOpaque(false);
        layeredPane.add(reelBase, new Integer(10));
        layeredPane.add(frontPanel, new Integer(20));
        layeredPane.add(coinCounter, new Integer(30));
        layeredPane.add(startLever, new Integer(40));
        frontPanel.setBounds(0, 0, WIDTH, HEIGHT);
        reelBase.setBounds(6, 10, WIDTH, HEIGHT);
        startLever.setBounds(16, 200, 80, 80);
        coinCounter.setBounds(180, 200, 150, 20);
        add(layeredPane);
        layeredPane.setBounds(0, 0, WIDTH, HEIGHT);

        // Ϗ
        base = new BasicSlotMachine(reelLeft, reelCenter, reelRight);

    }

    /* (override)
     * @see slotmachine.model.SlotMachine#getReels()
     */
    public Reel[] getReels() {

        return base.getReels();

    }

    /* (override)
     * @see slotmachine.model.SlotMachine#requestStart()
     */
    public void requestStart() {

        base.requestStart();

    }

    /* (override)
     * @see slotmachine.model.SlotMachine#requestStop()
     */
    public void requestStop() {

        timer.schedule(new ReelDelayStopTask(reelLeft), random.nextInt(3000) + 1000);
        timer.schedule(new ReelDelayStopTask(reelCenter), random.nextInt(1500) + 2500);
        timer.schedule(new ReelDelayStopTask(reelRight), random.nextInt(1000) + 3000);

    }

    /* (override)
     * @see slotmachine.model.SlotMachine#stoppedAll()
     */
    public synchronized boolean stoppedAll() {

        return base.stoppedAll();

    }

    /* (override)
     * @see slotmachine.model.SlotMachine#getReelElements()
     */
    public ReelElementGrid getReelElements() {

        return base.getReelElements();

    }

    /**
     * RC擾܂B
     * @return RC
     */
    public int getCoins() {

        return coins;

    }

    /**
     * RCZ܂B
     * @param count RC
     */
    public void addCoin(int count) {

        coins += count;
        coinCounter.coins = coins;
        coinCounter.repaint();

    }

    /**
     * bZ[W\܂B
     * @param message bZ[W
     */
    public void showMessage(String message) {

        frontPanel.setMessage(message);
        frontPanel.repaint();

    }

    /**
     * tgplłB
     */
    private static class FrontPanel extends JPanel {

        private static final int WIDTH1 = GraphicSlotMachine.WIDTH;
        private static final int WIDTH2 = 300;
        private static final int HEIGHT1 = GraphicSlotMachine.HEIGHT;
        private static final int HEIGHT2 = 152;
        private static final int X1 = 34;
        private static final int X2 = X1 + WIDTH2;
        private static final int Y1 = 32;
        private static final int Y2 = Y1 + HEIGHT2;
        private static final Color panelColor = new Color(0x1E2B86);
        private static final Color lineColor = new Color(0xD0E8E8);

        private String message;

        /**
         * FrontPanel𐶐܂B
         */
        public FrontPanel() {

            setOpaque(false);
            message = "";

        }

        /**
         * @param message
         */
        public void setMessage(String message) {

            this.message = message;

        }

        /* (override)
         * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
         */
        protected void paintComponent(Graphics g) {

            super.paintComponent(g);

            int position1 = 0;
            int position2 = HEIGHT2 / 6 * 1;
            int position3 = HEIGHT2 / 6 * 3;
            int position4 = HEIGHT2 / 6 * 5;
            int position5 = HEIGHT2;

            // LC
            g.setColor(lineColor);
            g.drawLine(X1, Y1 + position3, X1 + WIDTH2, Y1 + position3);
            g.drawLine(X1, Y1 + position2, X1 + WIDTH2, Y1 + position2);
            g.drawLine(X1, Y1 + position4, X1 + WIDTH2, Y1 + position4);
            g.drawLine(X1, Y1 + position1, X1 + WIDTH2, Y1 + position5);
            g.drawLine(X1, Y1 + position5, X1 + WIDTH2, Y1 + position1);

            // pl
            g.setColor(panelColor);
            g.fillRect(0, 0, WIDTH1, Y1 - 8); // 
            g.fillRect(0, Y2 + 8, WIDTH1, HEIGHT1); // 
            g.fillRect(0, 0, X1, HEIGHT1); // 
            g.fillRect(X2, 0, WIDTH1, HEIGHT1); // E

            // bZ[W
            if (message != null && message.trim().length() > 0) {
                g.setColor(Color.white);
                g.setFont(font);
                g.drawString(message, 120, 256 + 16);
            }

        }

    }

    /**
     * RCJE^łB
     */
    private static class CoinCounter extends JPanel {

        private static Font font = new Font("Monospaced", Font.BOLD, 20);

        private int coins;

        /* (override)
         * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
         */
        protected void paintComponent(Graphics g) {

            super.paintComponent(g);

            g.setColor(Color.black);
            g.fillRect(0, 0, getWidth(), getHeight());
            g.setColor(new Color(0xFF6666));
            g.setFont(font);

            StringBuffer buffer = new StringBuffer(" coins");
            buffer.insert(0, coins);
            while (buffer.length() < 12) {
                buffer.insert(0, ' ');
            }
            g.drawString(buffer.toString(), 0, 20);

        }

    }

    /**
     * X^[go[łB
     */
    private static class StartLever extends JPanel implements Runnable, MouseListener {

        private static final int WIDTH = 40;
        private static final int HEIGHT = 75;

        private Image image0;
        private Image image1;
        private GraphicSlotMachine machine;
        private boolean preparing;
        private boolean mousePressing;
        private boolean demanded;
        private int position;

        /**
         * X^[go[𐶐܂B
         * @param machine Xbg}V
         */
        public StartLever(GraphicSlotMachine machine) {

            setSize(WIDTH, HEIGHT);
            setOpaque(false);

            this.machine = machine;

            image0 = GraphicView.loadImage("lever0.gif");
            image1 = GraphicView.loadImage("lever1.gif");

            addMouseListener(this);

            preparing = false;
            mousePressing = false;
            demanded = false;

        }

        /**
         * XbhN܂B 
         */
        private synchronized void invokeThread() {

            if (machine.stoppedAll() && !preparing) {
                preparing = true;
                Thread thread = new Thread(machine.runnable);
                thread.start();
                preparing = false;
            }

        }

        /**
         * o[ʒuɖ߂܂B
         */
        private void resetPosition() {

            position = 0;
            repaint();

        }

        /* (override)
         * @see java.lang.Runnable#run()
         */
        public void run() {

            for (int i = 0; mousePressing && i < 50; i += 5) {
                position = i;
                repaint();
                try {
                    Thread.sleep(20);
                } catch (InterruptedException ex) {
                }
            }

        }

        /* (override)
         * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
         */
        protected void paintComponent(Graphics g) {

            super.paintComponent(g);

            g.drawImage(image0, 32, 0, 40, 75, this);
            g.drawImage(image1, 32, 0 + position, 40, 75, this);

        }

        /* (override)
         * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
         */
        public void mouseClicked(MouseEvent e) {

            if (demanded) {
                invokeThread();
                demanded = false;
            }

        }

        /* (override)
         * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
         */
        public void mouseEntered(MouseEvent e) {

            repaint();

        }

        /* (override)
         * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
         */
        public void mouseExited(MouseEvent e) {

            repaint();

        }

        /* (override)
         * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
         */
        public void mousePressed(MouseEvent e) {

            if (machine.stoppedAll() && !preparing) {
                resetPosition();
                mousePressing = true;
                synchronized (this) {
                    Thread thread = new Thread(this);
                    thread.start();
                }
            }

        }

        /* (override)
         * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
         */
        public void mouseReleased(MouseEvent e) {

            if (position > 30) {
                demanded = true;
            }
            resetPosition();
            mousePressing = false;
            repaint();

        }

    }

}