package slotmachine.graphic;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Timer;

import javax.swing.JPanel;

import slotmachine.model.Reel;
import slotmachine.model.ReelElement;
import slotmachine.model.ReelPosition;

/*
 * VK쐬 : 2005/05/08
 */

/**
 * fthpɎꂽ[łB
 */
public class GraphicReel extends JPanel implements Reel, Runnable {

    protected static final int WIDTH = 108;
    protected static final int HEIGHT = 220;

    private static final int DEGREE360 = 360;
    private static final int NUMBER_OF_ELEMENTS = 21;
    private static final double INTERVAL = DEGREE360 / 1f / NUMBER_OF_ELEMENTS;
    private static final double INCREMENTAL_VALUE = 0.32f;
    private static final long INTERVAL_REPAINT = 1000 / 60L;
    private static final long INTERVAL_INCREMENT = 1000 / 800L;
    private static final Color COLOR = new Color(0xEEEECC);

    private Timer timer;
    private GraphicReelElement[] elements;
    private double degree;
    private double degreeToStart;
    private double degreeToStop;
    private int stopPosition;
    private boolean active;
    private boolean stopRequested;
    private boolean stopDecided;

    /**
     * GraphicReel𐶐܂B
     * @param elements ̃[ɔzuvf̔z
     */
    public GraphicReel(GraphicReelElement[] elements) {

        // vf
        this.elements = elements;
        degreeToStop = -1;
        active = false;
        stopRequested = false;
        stopDecided = false;

        // O
        setSize(WIDTH, HEIGHT);
        setBackground(Color.white);
        setOpaque(false);

        // ^C}
        timer = new Timer();
        timer.scheduleAtFixedRate(new ReelRepaintTask(this), 0, INTERVAL_REPAINT);
        timer.scheduleAtFixedRate(new ReelRunningTask(this), 0, INTERVAL_INCREMENT);

        repaint();

    }

    /* (override)
     * @see java.lang.Runnable#run()
     */
    public void run() {

        if (!stopDecided && active) {
            // ]

            if (degreeToStart < INCREMENTAL_VALUE) {
                // X[X^[g
                degreeToStart += INCREMENTAL_VALUE / 500;
                setRelativeDegree(degreeToStart);
            } else {
                // ʏ]
                setRelativeDegree(INCREMENTAL_VALUE);
            }

            if (stopRequested) {
                // ~v
                degreeToStop -= INCREMENTAL_VALUE;
                if (degreeToStop < 0) {
                    stopDecided = true;
                    new ReelStopEffectTask(this);
                    degreeToStart = 0;
                }
            }

        }

    }

    /* (override)
     * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
     */
    protected void paintComponent(Graphics g) {

        super.paintComponent(g);

        int x = WIDTH / 4;

        g.setColor(COLOR);
        g.fillRect(x, 0, WIDTH + 64, HEIGHT);

        double d = degree;
        for (int i = 0, n = elements.length; i < n; i++, d += INTERVAL) {
            // 45 < x < 135 ̂Ƃ̂ݕ`
            if (d % 360 > 45 && d % 360 < 135) {
                int y = (int)(-Math.cos(Math.toRadians(d)) * getHeight() * 0.75) + 78;
                g.drawImage(elements[i].getImage(), x, y, this);
            }
        }

    }

    /* (override)
     * @see slotmachine.model.Reel#getElements()
     */
    public ReelElement[] getElements() {

        return elements;

    }

    /* (override)
     * @see slotmachine.model.Reel#requestStart()
     */
    public void requestStart() {

        active = true;
        stopRequested = false;
        stopDecided = false;

    }

    /* (override)
     * @see slotmachine.model.Reel#requestStop()
     */
    public void requestStop() {

        degreeToStop = INTERVAL - (degree % INTERVAL);
        stopRequested = true;

    }

    /* (override)
     * @see slotmachine.model.Reel#isStop()
     */
    public boolean isStop() {

        return !active;

    }

    /* (override)
     * @see slotmachine.model.Reel#getElement(slotmachine.model.ReelPosition)
     */
    public ReelElement getElement(ReelPosition pos) {

        stopPosition = getStopPosition();

        if (pos.equals(ReelPosition.UPPER)) {
            // i

            return elements[stopPosition];

        } else if (pos.equals(ReelPosition.MIDDLE)) {
            // i

            if (stopPosition + 1 >= elements.length) {
                return elements[stopPosition - elements.length + 1];
            }
            return elements[stopPosition + 1];

        } else if (pos.equals(ReelPosition.LOWER)) {
            // i

            if (stopPosition + 2 >= elements.length) {
                return elements[stopPosition - elements.length + 2];
            }
            return elements[stopPosition + 2];

        } else {
            // ^CG[

            throw new IllegalArgumentException("pos : " + pos);

        }

    }

    /**
     * Iɒ~Ԃɂ܂B
     * Ԃf邱ƂɒӂĂB
     */
    protected void forceStop() {

        active = false;
        stopRequested = true;
        stopDecided = true;

    }

    /**
     * ~ʒu擾܂B
     * iɒ~Ăvfpx画肵܂B
     * @return ~ʒu
     */
    private int getStopPosition() {

        int zeroPosition = (int)((degree + INTERVAL / 2) / INTERVAL);
        return (NUMBER_OF_ELEMENTS - zeroPosition + 4) % NUMBER_OF_ELEMENTS;

    }

    /**
     * pxԂ܂B
     * @return degree
     */
    public double getDegree() {

        return degree;

    }

    /**
     * pxݒ肵܂B
     * @param degree px
     */
    public void setDegree(double degree) {

        setRelativeDegree(degree - this.degree);

    }

    /**
     * px𑊑ΒlŐݒ肵܂B
     * @param relativeValue px̑Βl
     */
    public void setRelativeDegree(double relativeValue) {

        double degree = this.degree + relativeValue;
        double legalValue = (degree < 0 ? DEGREE360 + degree % DEGREE360 : degree % DEGREE360);
        this.degree = legalValue;

    }

}