package slotmachine.console;

import slotmachine.model.BasicSlotMachine;
import slotmachine.model.Reel;
import slotmachine.model.ReelElement;
import slotmachine.model.ReelElementGrid;
import slotmachine.model.SlotMachine;

/*
 * VK쐬 : 2005/04/30
 */

/**
 * R\[pɎꂽXbg}VłB
 */
public class ConsoleSlotMachine implements SlotMachine {

    private Reel reelLeft;
    private Reel reelCenter;
    private Reel reelRight;
    private BasicSlotMachine base;

    /**
     * ConsoleSlotMachine𐶐܂B
     */
    public ConsoleSlotMachine() {

        reelLeft = new ConsoleReel(new ReelElement[]{ConsoleReelElement.BELL,
                                                     ConsoleReelElement.PLUM,
                                                     ConsoleReelElement.CHERRY,
                                                     ConsoleReelElement.BELL,
                                                     ConsoleReelElement.CHERRY,
                                                     ConsoleReelElement.PLUM,
                                                     ConsoleReelElement.CHERRY,
                                                     ConsoleReelElement.DOLLAR,
                                                     ConsoleReelElement.PLUM,
                                                     ConsoleReelElement.CHERRY,
                                                     ConsoleReelElement.PLUM,
                                                     ConsoleReelElement.BELL,
                                                     ConsoleReelElement.PLUM,
                                                     ConsoleReelElement.CHERRY,
                                                     ConsoleReelElement.PLUM,
                                                     ConsoleReelElement.BAR,
                                                     ConsoleReelElement.CHERRY,
                                                     ConsoleReelElement.BELL,
                                                     ConsoleReelElement.PLUM,
                                                     ConsoleReelElement.BAR,
                                                     ConsoleReelElement.SEVEN});
        reelCenter = new ConsoleReel(new ReelElement[]{ConsoleReelElement.SEVEN,
                                                       ConsoleReelElement.BAR,
                                                       ConsoleReelElement.DOLLAR,
                                                       ConsoleReelElement.BELL,
                                                       ConsoleReelElement.CHERRY,
                                                       ConsoleReelElement.PLUM,
                                                       ConsoleReelElement.PLUM,
                                                       ConsoleReelElement.CHERRY,
                                                       ConsoleReelElement.PLUM,
                                                       ConsoleReelElement.BELL,
                                                       ConsoleReelElement.PLUM,
                                                       ConsoleReelElement.BELL,
                                                       ConsoleReelElement.DOLLAR,
                                                       ConsoleReelElement.PLUM,
                                                       ConsoleReelElement.BELL,
                                                       ConsoleReelElement.PLUM,
                                                       ConsoleReelElement.CHERRY,
                                                       ConsoleReelElement.DOLLAR,
                                                       ConsoleReelElement.PLUM,
                                                       ConsoleReelElement.CHERRY,
                                                       ConsoleReelElement.PLUM});
        reelRight = new ConsoleReel(new ReelElement[]{ConsoleReelElement.PLUM,
                                                      ConsoleReelElement.CHERRY,
                                                      ConsoleReelElement.DOLLAR,
                                                      ConsoleReelElement.PLUM,
                                                      ConsoleReelElement.BELL,
                                                      ConsoleReelElement.BAR,
                                                      ConsoleReelElement.PLUM,
                                                      ConsoleReelElement.BELL,
                                                      ConsoleReelElement.CHERRY,
                                                      ConsoleReelElement.PLUM,
                                                      ConsoleReelElement.DOLLAR,
                                                      ConsoleReelElement.SEVEN,
                                                      ConsoleReelElement.CHERRY,
                                                      ConsoleReelElement.PLUM,
                                                      ConsoleReelElement.BELL,
                                                      ConsoleReelElement.BAR,
                                                      ConsoleReelElement.DOLLAR,
                                                      ConsoleReelElement.PLUM,
                                                      ConsoleReelElement.DOLLAR,
                                                      ConsoleReelElement.CHERRY,
                                                      ConsoleReelElement.PLUM});

        // Ϗ
        base = new BasicSlotMachine(reelLeft, reelCenter, reelRight);

    }

    /* (override)
     * @see slotmachine.model.SlotMachine#getReels()
     */
    public Reel[] getReels() {

        return base.getReels();

    }

    /* (override)
     * @see slotmachine.model.SlotMachineController#requestStart()
     */
    public void requestStart() {

        base.requestStart();

    }

    /* (override)
     * @see slotmachine.model.SlotMachineController#requestStop()
     */
    public void requestStop() {

        base.requestStop();

    }

    /* (override)
     * @see slotmachine.model.SlotMachineController#stoppedAll()
     */
    public boolean stoppedAll() {

        return base.stoppedAll();

    }

    /* (override)
     * @see slotmachine.model.SlotMachineController#getTargetList()
     */
    public ReelElementGrid getReelElements() {

        return base.getReelElements();

    }

}