package slotmachine.console;

import java.util.Random;

import slotmachine.model.Reel;
import slotmachine.model.ReelElement;
import slotmachine.model.ReelPosition;

/*
 * VK쐬 : 2005/04/30
 */

/**
 * R\[pɎꂽ[łB
 */
public class ConsoleReel implements Reel {

    private static long seed = System.currentTimeMillis();

    private ReelElement[] elements;
    private boolean active;
    private int stopPosition;
    private Random random;

    /**
     * ConsoleReel𐶐܂B
     * @param elements ̃[ɔzuvf̔z
     */
    public ConsoleReel(ReelElement[] elements) {

        this.elements = elements;
        random = new Random(--seed);

    }

    /* (override)
     * @see slotmachine.model.Reel#getElements()
     */
    public ReelElement[] getElements() {

        return elements;

    }

    /* (override)
     * @see slotmachine.model.Reel#requestStart()
     */
    public void requestStart() {

        active = true;

    }

    /* (override)
     * @see slotmachine.model.Reel#requestStop()
     */
    public void requestStop() {

        stopPosition = getStopPosition();
        active = false;

    }

    /* (override)
     * @see slotmachine.model.Reel#getElement(slotmachine.model.LinePosition)
     */
    public ReelElement getElement(ReelPosition pos) {

        if (active) {
            stopPosition = getStopPosition();
        }

        if (pos.equals(ReelPosition.UPPER)) {
            // i

            return elements[stopPosition];

        } else if (pos.equals(ReelPosition.MIDDLE)) {
            // i

            if (stopPosition + 1 >= elements.length) {
                return elements[stopPosition - elements.length + 1];
            }
            return elements[stopPosition + 1];

        } else if (pos.equals(ReelPosition.LOWER)) {
            // i

            if (stopPosition + 2 >= elements.length) {
                return elements[stopPosition - elements.length + 2];
            }
            return elements[stopPosition + 2];

        } else {
            // ^CG[

            throw new IllegalArgumentException("pos : " + pos);

        }

    }

    /* (override)
     * @see slotmachine.model.Reel#isStop()
     */
    public boolean isStop() {

        return !active;

    }

    /**
     * [~ʒu擾܂B
     * @return [~ʒu
     */
    private int getStopPosition() {

        return random.nextInt(elements.length);

    }

}