package slotmachine;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;

import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JPanel;

import slotmachine.graphic.GraphicReelElement;
import slotmachine.graphic.GraphicSlotMachine;
import slotmachine.model.Prize;
import slotmachine.model.PrizeList;
import slotmachine.model.ReelElement;
import slotmachine.model.ReelElementGrid;

/*
 * VK쐬 : 2005/05/07
 */

/**
 * fthŃXbg}VQ[łB
 */
public final class GraphicView extends JApplet implements Runnable {

    /*
     * ConsoleViewƂ͓ɑ݂ȂOł邱
     */

    // ^Cg
    private static final String TITLE = "SLOT MACHINE";

    // Jn~܂ł̎ԁi~bj
    private static final long INTERVAL_FROM_START_TO_STOP = 1000;

    // C
    private static final int NUMBER_OF_LINES = 5;

    // ܂̐ݒ
    private static final PrizeList prizeList = new PrizeList();
    static {
        prizeList.addPrize(new Prize(new ReelElement[]{GraphicReelElement.SEVEN,
                                                       GraphicReelElement.SEVEN,
                                                       GraphicReelElement.SEVEN}, 500));
        prizeList.addPrize(new Prize(new ReelElement[]{GraphicReelElement.BAR,
                                                       GraphicReelElement.BAR,
                                                       GraphicReelElement.BAR}, 100));
        prizeList.addPrize(new Prize(new ReelElement[]{GraphicReelElement.DOLLAR,
                                                       GraphicReelElement.DOLLAR,
                                                       GraphicReelElement.DOLLAR}, 50));
        prizeList.addPrize(new Prize(new ReelElement[]{GraphicReelElement.BELL,
                                                       GraphicReelElement.BELL,
                                                       GraphicReelElement.BELL}, 10));
        prizeList.addPrize(new Prize(new ReelElement[]{GraphicReelElement.CHERRY,
                                                       GraphicReelElement.CHERRY,
                                                       GraphicReelElement.CHERRY}, 5));
        prizeList.addPrize(new Prize(new ReelElement[]{GraphicReelElement.CHERRY,
                                                       GraphicReelElement.CHERRY,
                                                       ReelElement.ANY}, 1));
    }

    // Xbg}V{
    private GraphicSlotMachine machine;

    // stO
    private boolean isRunning;

    // RC̏l
    private static final int DEFAULT_COIN = 100;

    // RCۑt@C
    private static final File dataFile = new File(".", "coins");

    /**
     * GraphicView𐶐܂B
     */
    public GraphicView() {

        // r[
        setSize(360, 300);
        getContentPane().setBackground(Color.blue);

        // Xbg}V{́i[j
        machine = new GraphicSlotMachine(this);

        // CAEg
        JPanel panel = new JPanel(null);
        panel.add(machine);
        machine.setBounds(0, 0, 400, 400);
        getContentPane().add(panel);

        // RC
        int coins;
        try {
            coins = loadCoins();
        } catch (IOException ex) {
            coins = DEFAULT_COIN;
        }

        // Q[̏
        machine.addCoin(coins);

    }

    /* (override)
     * @see java.lang.Runnable#run()
     */
    public void run() {

        if (!isRunning && machine.getCoins() > 0) {
            isRunning = true;
            do {
                play();
            } while (machine.getCoins() > 0 && isAutoMode());
            isRunning = false;
        }

        if (machine.getCoins() <= 0) {
            machine.showMessage("GAME OVER");
        }

    }

    /**
     * Q[Ps܂B 
     */
    private synchronized void play() {

        // Jn
        machine.showMessage("");
        machine.addCoin(-1);
        machine.requestStart();
        sleep(INTERVAL_FROM_START_TO_STOP);

        // ~v
        machine.requestStop();
        while (!machine.stoppedAll()) {
            sleep(200);
        }

        // ~[vf擾
        ReelElementGrid targets = machine.getReelElements();

        // ܃`FbN
        int won = 0;
        for (int i = 1; i <= NUMBER_OF_LINES; i++) {
            won += getWonPrize(targets, i).getCoins();
        }

        // ʏ
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        if (won > 0) {
            out.print(won);
            out.print("  l܂");
        } else {
            out.print("͂܂");
        }
        machine.showMessage(buffer.toString());
        machine.addCoin(won);

        // ۑ
        try {
            saveCoins(machine.getCoins());
        } catch (IOException ex) {
            // G[͖
        }

        // ̊Jn܂ł̊Ԋu
        sleep(500);

    }

    /**
     * w肵Ԃo߂܂ŏ~܂B
     * @param milliseconds ~b
     */
    private static void sleep(long milliseconds) {

        try {
            Thread.sleep(milliseconds);
        } catch (InterruptedException ex) {
        }

    }

    /**
     * RCt@Cǂݍ݂܂B
     * @return RC
     * @throws IOException o̓G[ꍇ
     */
    private static int loadCoins() throws IOException {

        try {
            FileReader filereader = new FileReader(dataFile);
            try {
                BufferedReader reader = new BufferedReader(filereader);
                return Integer.parseInt(reader.readLine());
            } finally {
                filereader.close();
            }
        } catch (RuntimeException ex) {
            throw new IOException(ex.getMessage());
        }

    }

    /**
     * RCt@Cɕۑ܂B
     * @param coins RC
     * @throws IOException o̓G[ꍇ
     */
    private static void saveCoins(int coins) throws IOException {

        try {
            FileWriter filewriter = new FileWriter(dataFile);
            try {
                PrintWriter writer = new PrintWriter(filewriter);
                writer.print(coins);
            } finally {
                filewriter.close();
            }
        } catch (RuntimeException ex) {
            throw new IOException(ex.getMessage());
        }

    }

    // B@\Fs[hpt@C
    private File autoFile = new File(".", "auto");

    /**
     * 샂[hǂ𒲍܂B
     * @return 샂[hȂ<code>true</code>AłȂ<code>false</code>
     */
    private synchronized boolean isAutoMode() {

        try {
            if (autoFile.isFile()) {
                return true;
            }
        } catch (RuntimeException ex) {
        }
        return false;

    }

    /**
     * ܂`FbN܂B
     * @param targets ~[vf
     * @param lineNumber Cԍ
     *         1 : i
     *         2 : i
     *         3 : i
     *         4 : Eオ
     *         5 : E
     * @return 
     */
    private static Prize getWonPrize(ReelElementGrid targets, int lineNumber) {

        switch (lineNumber) {
            case 1: // i
                return prizeList.getWonPrize(new ReelElement[]{targets.get(ReelElementGrid.LEFT,
                                                                           ReelElementGrid.MIDDLE),
                                                               targets.get(ReelElementGrid.CENTER,
                                                                           ReelElementGrid.MIDDLE),
                                                               targets.get(ReelElementGrid.RIGHT,
                                                                           ReelElementGrid.MIDDLE)});
            case 2: // i
                return prizeList.getWonPrize(new ReelElement[]{targets.get(ReelElementGrid.LEFT,
                                                                           ReelElementGrid.UPPER),
                                                               targets.get(ReelElementGrid.CENTER,
                                                                           ReelElementGrid.UPPER),
                                                               targets.get(ReelElementGrid.RIGHT,
                                                                           ReelElementGrid.UPPER)});
            case 3: // i
                return prizeList.getWonPrize(new ReelElement[]{targets.get(ReelElementGrid.LEFT,
                                                                           ReelElementGrid.LOWER),
                                                               targets.get(ReelElementGrid.CENTER,
                                                                           ReelElementGrid.LOWER),
                                                               targets.get(ReelElementGrid.RIGHT,
                                                                           ReelElementGrid.LOWER)});
            case 4: // Eオ
                return prizeList.getWonPrize(new ReelElement[]{targets.get(ReelElementGrid.LEFT,
                                                                           ReelElementGrid.LOWER),
                                                               targets.get(ReelElementGrid.CENTER,
                                                                           ReelElementGrid.MIDDLE),
                                                               targets.get(ReelElementGrid.RIGHT,
                                                                           ReelElementGrid.UPPER)});
            case 5: // E
                return prizeList.getWonPrize(new ReelElement[]{targets.get(ReelElementGrid.LEFT,
                                                                           ReelElementGrid.UPPER),
                                                               targets.get(ReelElementGrid.CENTER,
                                                                           ReelElementGrid.MIDDLE),
                                                               targets.get(ReelElementGrid.RIGHT,
                                                                           ReelElementGrid.LOWER)});
            default:
                throw new IllegalArgumentException("line : " + lineNumber);
        }

    }

    /**
     * C[Wǂݍ݂܂B 
     * @param path C[Wt@C̃pX
     * @return C[W
     */
    public static Image loadImage(String path) {

        URL url = GraphicSlotMachine.class.getResource("/" + path);
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        return image;

    }

    /**
     * fthŃXbg}VN܂B
     * @param args sv
     */
    public static void main(String[] args) {

        GraphicView view = new GraphicView();
        JFrame frame = new JFrame();
        frame.setTitle(TITLE);
        frame.setSize(view.getWidth() + 16, view.getHeight() + 16);
        frame.setResizable(false);
        frame.getContentPane().add(view);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setIconImage(loadImage("icon.gif"));

        frame.setLocation(100, 100);
        frame.show();
        frame.validate();

    }

}