package slotmachine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

import slotmachine.console.ConsoleReelElement;
import slotmachine.console.ConsoleSlotMachine;
import slotmachine.model.Prize;
import slotmachine.model.PrizeList;
import slotmachine.model.Reel;
import slotmachine.model.ReelElement;
import slotmachine.model.ReelElementGrid;
import slotmachine.model.SlotMachine;

/*
 * VK쐬 : 2005/05/07
 */

/**
 * R\[ŃXbg}VQ[łB
 * 
 * <p>
 * PɂPȏ̐w肷ƁA
 * w肵񐔂ŎssA̎ɂҒlZo܂B
 * </p>
 * <p>
 * PɃ[w肷ƁA
 * [̔z̑Sgݍ킹ҒlZo܂B
 * </p>
 * <p>
 * LȊȌꍇ́AΘb[hŎs܂B
 * </p>
 */
public final class ConsoleView {

    /*
     * GraphicViewƂ͓ɑ݂ȂOł邱
     */

    // ܂̐ݒ
    private static final PrizeList prizeList = new PrizeList();
    static {
        prizeList.addPrize(new Prize(new ReelElement[]{ConsoleReelElement.SEVEN,
                                                       ConsoleReelElement.SEVEN,
                                                       ConsoleReelElement.SEVEN}, 500));
        prizeList.addPrize(new Prize(new ReelElement[]{ConsoleReelElement.BAR,
                                                       ConsoleReelElement.BAR,
                                                       ConsoleReelElement.BAR}, 100));
        prizeList.addPrize(new Prize(new ReelElement[]{ConsoleReelElement.DOLLAR,
                                                       ConsoleReelElement.DOLLAR,
                                                       ConsoleReelElement.DOLLAR}, 50));
        prizeList.addPrize(new Prize(new ReelElement[]{ConsoleReelElement.BELL,
                                                       ConsoleReelElement.BELL,
                                                       ConsoleReelElement.BELL}, 10));
        prizeList.addPrize(new Prize(new ReelElement[]{ConsoleReelElement.CHERRY,
                                                       ConsoleReelElement.CHERRY,
                                                       ConsoleReelElement.CHERRY}, 5));
        prizeList.addPrize(new Prize(new ReelElement[]{ConsoleReelElement.CHERRY,
                                                       ConsoleReelElement.CHERRY,
                                                       ReelElement.ANY}, 1));
    }

    // RC̏l
    private static final int DEFAULT_COIN = 100;

    // RCۑt@C
    private static final File dataFile = new File(".", "coins");

    // [Uo
    private static final BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
    private static final PrintStream out = System.out;

    // 萔
    private static final String SEPARATOR = "----------------";
    private static final String EMPTY = "";
    private static final int NUMBER_OF_LINES = 5;

    /**
     * ~G\܂B
     * @param targets ~G̃Zbg
     */
    private static void printStopElements(ReelElementGrid targets) {

        out.println(' ' + SEPARATOR);

        out.print(" | ");
        out.print(targets.get(ReelElementGrid.LEFT, ReelElementGrid.UPPER));
        out.print(" | ");
        out.print(targets.get(ReelElementGrid.CENTER, ReelElementGrid.UPPER));
        out.print(" | ");
        out.print(targets.get(ReelElementGrid.RIGHT, ReelElementGrid.UPPER));
        out.print(" | ");
        out.println();
        out.print(" | ");
        out.print(targets.get(ReelElementGrid.LEFT, ReelElementGrid.MIDDLE));
        out.print(" | ");
        out.print(targets.get(ReelElementGrid.CENTER, ReelElementGrid.MIDDLE));
        out.print(" | ");
        out.print(targets.get(ReelElementGrid.RIGHT, ReelElementGrid.MIDDLE));
        out.print(" | ");
        out.println();
        out.print(" | ");
        out.print(targets.get(ReelElementGrid.LEFT, ReelElementGrid.LOWER));
        out.print(" | ");
        out.print(targets.get(ReelElementGrid.CENTER, ReelElementGrid.LOWER));
        out.print(" | ");
        out.print(targets.get(ReelElementGrid.RIGHT, ReelElementGrid.LOWER));
        out.print(" | ");

        out.println();
        out.println(' ' + SEPARATOR);

    }

    /**
     * ͑҂܂B
     * @param message Y郁bZ[W
     * @return ͕
     */
    private static String getInput(String message) {

        out.print(message);
        try {
            return reader.readLine();
        } catch (IOException ex) {
            return EMPTY;
        }

    }

    /**
     * ܂`FbN܂B
     * @param targets ~[vf
     * @param lineNumber Cԍ
     *         1 : i
     *         2 : i
     *         3 : i
     *         4 : Eオ
     *         5 : E
     * @return 
     */
    private static Prize getWonPrize(ReelElementGrid targets, int lineNumber) {

        switch (lineNumber) {
            case 1: // i
                return prizeList.getWonPrize(new ReelElement[]{targets.get(ReelElementGrid.LEFT,
                                                                           ReelElementGrid.MIDDLE),
                                                               targets.get(ReelElementGrid.CENTER,
                                                                           ReelElementGrid.MIDDLE),
                                                               targets.get(ReelElementGrid.RIGHT,
                                                                           ReelElementGrid.MIDDLE)});
            case 2: // i
                return prizeList.getWonPrize(new ReelElement[]{targets.get(ReelElementGrid.LEFT,
                                                                           ReelElementGrid.UPPER),
                                                               targets.get(ReelElementGrid.CENTER,
                                                                           ReelElementGrid.UPPER),
                                                               targets.get(ReelElementGrid.RIGHT,
                                                                           ReelElementGrid.UPPER)});
            case 3: // i
                return prizeList.getWonPrize(new ReelElement[]{targets.get(ReelElementGrid.LEFT,
                                                                           ReelElementGrid.LOWER),
                                                               targets.get(ReelElementGrid.CENTER,
                                                                           ReelElementGrid.LOWER),
                                                               targets.get(ReelElementGrid.RIGHT,
                                                                           ReelElementGrid.LOWER)});
            case 4: // Eオ
                return prizeList.getWonPrize(new ReelElement[]{targets.get(ReelElementGrid.LEFT,
                                                                           ReelElementGrid.LOWER),
                                                               targets.get(ReelElementGrid.CENTER,
                                                                           ReelElementGrid.MIDDLE),
                                                               targets.get(ReelElementGrid.RIGHT,
                                                                           ReelElementGrid.UPPER)});
            case 5: // E
                return prizeList.getWonPrize(new ReelElement[]{targets.get(ReelElementGrid.LEFT,
                                                                           ReelElementGrid.UPPER),
                                                               targets.get(ReelElementGrid.CENTER,
                                                                           ReelElementGrid.MIDDLE),
                                                               targets.get(ReelElementGrid.RIGHT,
                                                                           ReelElementGrid.LOWER)});
            default:
                throw new IllegalArgumentException("line : " + lineNumber);
        }

    }

    /**
     * RCt@Cǂݍ݂܂B
     * @return RC
     * @throws IOException o̓G[ꍇ
     */
    private static int loadCoins() throws IOException {

        FileReader filereader = new FileReader(dataFile);
        try {
            BufferedReader reader = new BufferedReader(filereader);
            return Integer.parseInt(reader.readLine());
        } catch (RuntimeException ex) {
            throw new IOException(ex.getMessage());
        } finally {
            filereader.close();
        }

    }

    /**
     * RCt@Cɕۑ܂B
     * @param coins RC
     * @throws IOException o̓G[ꍇ
     */
    private static void saveCoins(int coins) throws IOException {

        FileWriter filewriter = new FileWriter(dataFile);
        try {
            PrintWriter writer = new PrintWriter(filewriter);
            writer.print(coins);
        } catch (RuntimeException ex) {
            throw new IOException(ex.getMessage());
        } finally {
            filewriter.close();
        }

    }

    /**
     * Ғl̃`FbNs܂B
     * @param times 1ȏ̏ꍇ͎s񐔁ij
     *               [̏ꍇ͑Ŏs
     */
    private static void tryOut(int times) {

        SlotMachine machine = new ConsoleSlotMachine();
        int won = 0;
        Map map = new HashMap();
        for (int i = 0, n = prizeList.size(); i < n; i++) {
            map.put(prizeList.get(i), new Integer(0));
        }

        /*
         * s
         */
        if (times == 0) {
            // 

            Reel[] reels = machine.getReels();
            ReelElement[] elements1 = reels[0].getElements();
            ReelElement[] elements2 = reels[1].getElements();
            ReelElement[] elements3 = reels[2].getElements();

            for (int x = 0; x < elements1.length; x++) {
                for (int y = 0; y < elements2.length; y++) {
                    for (int z = 0; z < elements3.length; z++) {

                        // ~Ɖ肵[z
                        ReelElement[] target1 = new ReelElement[]{elements1[x],
                                                                  elements1[(x + 1) % 21],
                                                                  elements1[(x + 2) % 21]};
                        ReelElement[] target2 = new ReelElement[]{elements2[y],
                                                                  elements2[(y + 1) % 21],
                                                                  elements2[(y + 2) % 21]};
                        ReelElement[] target3 = new ReelElement[]{elements3[z],
                                                                  elements3[(z + 1) % 21],
                                                                  elements3[(z + 2) % 21]};
                        ReelElementGrid targets = new ReelElementGrid(new ReelElement[][]{target1,
                                                                                          target2,
                                                                                          target3});
                        // ܃`FbN
                        for (int j = 1; j <= NUMBER_OF_LINES; j++) {
                            Prize prize = getWonPrize(targets, j);
                            won += prize.getCoins();
                            Integer count = (Integer)map.get(prize);
                            if (count != null) {
                                map.put(prize, new Integer(count.intValue() + 1));
                            }
                        }

                        ++times;

                    }
                }
            }

        } else {
            // 

            for (int i = 0; i < times; i++) {

                // Jn
                machine.requestStart();

                // ~v
                while (true) {
                    machine.requestStop();
                    if (machine.stoppedAll()) {
                        // ʏ͑~
                        break;
                    }
                }

                // ~[vf擾
                ReelElementGrid targets = machine.getReelElements();

                // ܃`FbN
                for (int j = 1; j <= NUMBER_OF_LINES; j++) {
                    Prize prize = getWonPrize(targets, j);
                    won += prize.getCoins();
                    Integer count = (Integer)map.get(prize);
                    if (count != null) {
                        map.put(prize, new Integer(count.intValue() + 1));
                    }
                }

            }

        }

        /*
         * ʏo
         */
        out.println("            s");
        out.println(SEPARATOR + SEPARATOR);

        // l܂̃Xgo
        for (int i = 0, n = prizeList.size(); i < n; i++) {
            Prize key = prizeList.getPrize(i);
            Integer value = (Integer)map.get(key);
            out.print(key);
            out.print(" : ");
            // h
            StringBuffer buffer = new StringBuffer();
            buffer.append(value);
            while (buffer.length() <= String.valueOf(times).length()) {
                buffer.insert(0, ' ');
            }
            out.print(buffer);
            out.println(" ");
        }
        out.println(SEPARATOR + SEPARATOR);

        // Wvʏo
        out.println("  s : " + times + " ");
        out.println("  l : " + won + " ");
        out.println("  Ғl : " + (100f * won / times) + " %");
        out.println(SEPARATOR + SEPARATOR);

    }

    /**
     * R\[ŃXbg}VN܂B
     * @param args PɂPȏ̐w肷ƁAs[h
     *              PɃ[w肷ƁAҒlZo
     *              ȗƑΘb[h
     */
    public static void main(String[] args) {

        out.println();
        out.println(SEPARATOR + SEPARATOR);
        out.println("         SLOT  MACHINE");
        out.println(SEPARATOR + SEPARATOR);

        if (args.length > 0) {
            // ҒlvZ ()

            try {
                tryOut(Integer.parseInt(args[0]));
                System.exit(0);
            } catch (NumberFormatException ex) {
                // ʏQ[Ƃ݂Ȃ
            }

        }

        // Xbg}V
        SlotMachine machine = new ConsoleSlotMachine();

        // RC
        int coins;
        try {
            coins = loadCoins();
        } catch (IOException ex) {
            coins = DEFAULT_COIN;
        }

        // ܃Xgiŏj
        out.println("   ܃Xg ");
        out.print(prizeList);
        out.println(SEPARATOR + SEPARATOR);

        while (true) {

            out.print("݂̎RC : ");
            out.println(coins);

            // Q[sH
            if (coins <= 0) {
                out.println("GAME OVER!");
                break;
            }

            String input = getInput("( ENTERŎs, ͂ŏI ) > ");
            if (!input.equals(EMPTY)) {
                break;
            }

            // Jn
            --coins;
            machine.requestStart();

            // ~v
            while (true) {
                machine.requestStop();
                if (machine.stoppedAll()) {
                    // ʏ͑~
                    break;
                }
            }

            // ~[vf擾
            ReelElementGrid targets = machine.getReelElements();

            // ~G̕\
            printStopElements(targets);

            // ܃`FbN
            int won = 0;
            for (int i = 1; i <= NUMBER_OF_LINES; i++) {
                won += getWonPrize(targets, i).getCoins();
            }

            // ʏ
            if (won > 0) {
                out.print(won);
                out.println("  l܂");
                out.println();
                coins += won;
            } else {
                out.println("͂܂");
                out.println();
            }

            // ۑ
            try {
                saveCoins(coins);
            } catch (IOException ex) {
                // G[͖
            }

        }

    }

}