/*
 * Decompiled with CFR 0.152.
 */
package slotmachine.model;

import slotmachine.model.ReelElement;

public final class Prize
implements Comparable {
    private ReelElement[] elements;
    private int coins;

    public Prize(ReelElement[] reelElementArray, int n) {
        this.elements = reelElementArray;
        this.coins = n;
    }

    public int getCoins() {
        return this.coins;
    }

    public boolean matched(ReelElement[] reelElementArray) {
        if (reelElementArray == null || reelElementArray.length != this.elements.length) {
            return false;
        }
        int n = 0;
        int n2 = reelElementArray.length;
        while (n < n2) {
            if (!reelElementArray[n].matched(this.elements[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int compareTo(Object object) {
        if (object instanceof Prize) {
            Prize prize = (Prize)object;
            return this.coins - prize.coins;
        }
        return this.coins + 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        int n2 = this.elements.length;
        while (n < n2) {
            stringBuffer.append(' ');
            stringBuffer.append(this.elements[n]);
            ++n;
        }
        stringBuffer.append(" ] - $ ");
        stringBuffer.append(this.coins);
        while (stringBuffer.length() <= 16) {
            stringBuffer.insert(14, ' ');
        }
        return stringBuffer.toString();
    }
}

