/*
 * Decompiled with CFR 0.152.
 */
package slotmachine.model;

import slotmachine.model.Reel;
import slotmachine.model.ReelElement;
import slotmachine.model.ReelElementGrid;
import slotmachine.model.ReelPosition;
import slotmachine.model.SlotMachine;

public final class BasicSlotMachine
implements SlotMachine {
    private Reel reelLeft;
    private Reel reelCenter;
    private Reel reelRight;

    public BasicSlotMachine(Reel reel, Reel reel2, Reel reel3) {
        this.reelLeft = reel;
        this.reelCenter = reel2;
        this.reelRight = reel3;
    }

    public Reel[] getReels() {
        return new Reel[]{this.reelLeft, this.reelCenter, this.reelRight};
    }

    public void requestStart() {
        this.reelLeft.requestStart();
        this.reelCenter.requestStart();
        this.reelRight.requestStart();
    }

    public void requestStop() {
        this.reelLeft.requestStop();
        this.reelCenter.requestStop();
        this.reelRight.requestStop();
    }

    public boolean stoppedAll() {
        return this.reelLeft.isStop() && this.reelCenter.isStop() && this.reelRight.isStop();
    }

    public ReelElementGrid getReelElements() {
        ReelElement[] reelElementArray = new ReelElement[]{this.reelLeft.getElement(ReelPosition.UPPER), this.reelLeft.getElement(ReelPosition.MIDDLE), this.reelLeft.getElement(ReelPosition.LOWER)};
        ReelElement[] reelElementArray2 = new ReelElement[]{this.reelCenter.getElement(ReelPosition.UPPER), this.reelCenter.getElement(ReelPosition.MIDDLE), this.reelCenter.getElement(ReelPosition.LOWER)};
        ReelElement[] reelElementArray3 = new ReelElement[]{this.reelRight.getElement(ReelPosition.UPPER), this.reelRight.getElement(ReelPosition.MIDDLE), this.reelRight.getElement(ReelPosition.LOWER)};
        return new ReelElementGrid(new ReelElement[][]{reelElementArray, reelElementArray2, reelElementArray3});
    }
}

