/*
 * Decompiled with CFR 0.152.
 */
package slotmachine.graphic;

import java.util.Timer;
import java.util.TimerTask;
import slotmachine.graphic.GraphicReel;

public class ReelStopEffectTask
extends TimerTask {
    private static final int DEGREE360 = 360;
    private GraphicReel reel;
    private Timer timer;
    private int frameNumber;
    private double fixedDegree;
    private boolean motionFinished;

    public ReelStopEffectTask(GraphicReel graphicReel) {
        this.reel = graphicReel;
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)this, 0L, 5L);
        this.fixedDegree = graphicReel.getDegree();
    }

    public void run() {
        if (this.motionFinished) {
            this.timer.cancel();
        } else {
            double d = this.calculateAttenuatingSineWave((double)(++this.frameNumber / 2) + 0.5);
            this.reel.setDegree(this.fixedDegree + d * 256.0);
            if (this.frameNumber > 100) {
                this.reel.forceStop();
                this.reel.setDegree(this.fixedDegree);
                this.motionFinished = true;
            }
        }
    }

    private double calculateAttenuatingSineWave(double d) {
        double d2 = (d *= 47.2) < 0.0 ? 360.0 + d % 360.0 : d % 360.0;
        double d3 = Math.sin(Math.toRadians(d2));
        double d4 = d3 * Math.pow(1.0 - (d + 2.0) / (d + 6.0), 2.0);
        return d4 * 255.0;
    }
}

