/*
 * Decompiled with CFR 0.152.
 */
package slotmachine.graphic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import slotmachine.GraphicView;
import slotmachine.graphic.GraphicReel;
import slotmachine.graphic.GraphicReelElement;
import slotmachine.graphic.ReelDelayStopTask;
import slotmachine.model.BasicSlotMachine;
import slotmachine.model.Reel;
import slotmachine.model.ReelElementGrid;
import slotmachine.model.SlotMachine;

public class GraphicSlotMachine
extends JPanel
implements SlotMachine {
    private static final int WIDTH = 400;
    private static final int HEIGHT = 400;
    private static final Font font = new Font("Monospaced", 1, 24);
    private static Random random = new Random(System.currentTimeMillis());
    private CoinCounter coinCounter;
    private FrontPanel frontPanel;
    private GraphicReel reelLeft;
    private GraphicReel reelCenter;
    private GraphicReel reelRight;
    private BasicSlotMachine base;
    private Timer timer;
    private Runnable runnable;
    private int coins;

    public GraphicSlotMachine(Runnable runnable) {
        this.runnable = runnable;
        this.timer = new Timer();
        this.reelLeft = new GraphicReel(new GraphicReelElement[]{GraphicReelElement.BELL, GraphicReelElement.PLUM, GraphicReelElement.CHERRY, GraphicReelElement.BELL, GraphicReelElement.CHERRY, GraphicReelElement.PLUM, GraphicReelElement.CHERRY, GraphicReelElement.DOLLAR, GraphicReelElement.PLUM, GraphicReelElement.CHERRY, GraphicReelElement.PLUM, GraphicReelElement.BELL, GraphicReelElement.PLUM, GraphicReelElement.CHERRY, GraphicReelElement.PLUM, GraphicReelElement.BAR, GraphicReelElement.CHERRY, GraphicReelElement.BELL, GraphicReelElement.PLUM, GraphicReelElement.BAR, GraphicReelElement.SEVEN});
        this.reelCenter = new GraphicReel(new GraphicReelElement[]{GraphicReelElement.SEVEN, GraphicReelElement.BAR, GraphicReelElement.DOLLAR, GraphicReelElement.BELL, GraphicReelElement.CHERRY, GraphicReelElement.PLUM, GraphicReelElement.PLUM, GraphicReelElement.CHERRY, GraphicReelElement.PLUM, GraphicReelElement.BELL, GraphicReelElement.PLUM, GraphicReelElement.BELL, GraphicReelElement.DOLLAR, GraphicReelElement.PLUM, GraphicReelElement.BELL, GraphicReelElement.PLUM, GraphicReelElement.CHERRY, GraphicReelElement.DOLLAR, GraphicReelElement.PLUM, GraphicReelElement.CHERRY, GraphicReelElement.PLUM});
        this.reelRight = new GraphicReel(new GraphicReelElement[]{GraphicReelElement.PLUM, GraphicReelElement.CHERRY, GraphicReelElement.DOLLAR, GraphicReelElement.PLUM, GraphicReelElement.BELL, GraphicReelElement.BAR, GraphicReelElement.PLUM, GraphicReelElement.BELL, GraphicReelElement.CHERRY, GraphicReelElement.PLUM, GraphicReelElement.DOLLAR, GraphicReelElement.SEVEN, GraphicReelElement.CHERRY, GraphicReelElement.PLUM, GraphicReelElement.BELL, GraphicReelElement.BAR, GraphicReelElement.DOLLAR, GraphicReelElement.PLUM, GraphicReelElement.DOLLAR, GraphicReelElement.CHERRY, GraphicReelElement.PLUM});
        this.setOpaque(false);
        this.setLayout(null);
        JPanel jPanel = new JPanel(null);
        jPanel.setBackground(new Color(0x400000));
        jPanel.setOpaque(true);
        jPanel.add(this.reelLeft);
        jPanel.add(this.reelCenter);
        jPanel.add(this.reelRight);
        this.reelLeft.setBounds(10, 10, 108, 220);
        this.reelCenter.setBounds(110, 10, 108, 220);
        this.reelRight.setBounds(210, 10, 108, 220);
        this.frontPanel = new FrontPanel();
        StartLever startLever = new StartLever(this);
        this.coinCounter = new CoinCounter();
        JLayeredPane jLayeredPane = new JLayeredPane();
        jLayeredPane.setOpaque(false);
        jLayeredPane.add((Component)jPanel, new Integer(10));
        jLayeredPane.add((Component)this.frontPanel, new Integer(20));
        jLayeredPane.add((Component)this.coinCounter, new Integer(30));
        jLayeredPane.add((Component)startLever, new Integer(40));
        this.frontPanel.setBounds(0, 0, 400, 400);
        jPanel.setBounds(6, 10, 400, 400);
        startLever.setBounds(16, 200, 80, 80);
        this.coinCounter.setBounds(180, 200, 150, 20);
        this.add(jLayeredPane);
        jLayeredPane.setBounds(0, 0, 400, 400);
        this.base = new BasicSlotMachine(this.reelLeft, this.reelCenter, this.reelRight);
    }

    public Reel[] getReels() {
        return this.base.getReels();
    }

    public void requestStart() {
        this.base.requestStart();
    }

    public void requestStop() {
        this.timer.schedule((TimerTask)new ReelDelayStopTask(this.reelLeft), random.nextInt(3000) + 1000);
        this.timer.schedule((TimerTask)new ReelDelayStopTask(this.reelCenter), random.nextInt(1500) + 2500);
        this.timer.schedule((TimerTask)new ReelDelayStopTask(this.reelRight), random.nextInt(1000) + 3000);
    }

    public synchronized boolean stoppedAll() {
        return this.base.stoppedAll();
    }

    public ReelElementGrid getReelElements() {
        return this.base.getReelElements();
    }

    public int getCoins() {
        return this.coins;
    }

    public void addCoin(int n) {
        this.coins += n;
        this.coinCounter.coins = this.coins;
        this.coinCounter.repaint();
    }

    public void showMessage(String string) {
        this.frontPanel.setMessage(string);
        this.frontPanel.repaint();
    }

    private static class StartLever
    extends JPanel
    implements Runnable,
    MouseListener {
        private static final int WIDTH = 40;
        private static final int HEIGHT = 75;
        private Image image0;
        private Image image1;
        private GraphicSlotMachine machine;
        private boolean preparing;
        private boolean mousePressing;
        private boolean demanded;
        private int position;

        public StartLever(GraphicSlotMachine graphicSlotMachine) {
            this.setSize(40, 75);
            this.setOpaque(false);
            this.machine = graphicSlotMachine;
            this.image0 = GraphicView.loadImage("lever0.gif");
            this.image1 = GraphicView.loadImage("lever1.gif");
            this.addMouseListener(this);
            this.preparing = false;
            this.mousePressing = false;
            this.demanded = false;
        }

        private synchronized void invokeThread() {
            if (this.machine.stoppedAll() && !this.preparing) {
                this.preparing = true;
                Thread thread = new Thread(this.machine.runnable);
                thread.start();
                this.preparing = false;
            }
        }

        private void resetPosition() {
            this.position = 0;
            this.repaint();
        }

        public void run() {
            int n = 0;
            while (this.mousePressing && n < 50) {
                this.position = n;
                this.repaint();
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n += 5;
            }
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.drawImage(this.image0, 32, 0, 40, 75, this);
            graphics.drawImage(this.image1, 32, 0 + this.position, 40, 75, this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.demanded) {
                this.invokeThread();
                this.demanded = false;
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.machine.stoppedAll() && !this.preparing) {
                this.resetPosition();
                this.mousePressing = true;
                StartLever startLever = this;
                synchronized (startLever) {
                    Thread thread = new Thread(this);
                    thread.start();
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.position > 30) {
                this.demanded = true;
            }
            this.resetPosition();
            this.mousePressing = false;
            this.repaint();
        }
    }

    private static class CoinCounter
    extends JPanel {
        private static Font font = new Font("Monospaced", 1, 20);
        private int coins;

        private CoinCounter() {
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(new Color(0xFF6666));
            graphics.setFont(font);
            StringBuffer stringBuffer = new StringBuffer(" coins");
            stringBuffer.insert(0, this.coins);
            while (stringBuffer.length() < 12) {
                stringBuffer.insert(0, ' ');
            }
            graphics.drawString(stringBuffer.toString(), 0, 20);
        }
    }

    private static class FrontPanel
    extends JPanel {
        private static final int WIDTH1 = 400;
        private static final int WIDTH2 = 300;
        private static final int HEIGHT1 = 400;
        private static final int HEIGHT2 = 152;
        private static final int X1 = 34;
        private static final int X2 = 334;
        private static final int Y1 = 32;
        private static final int Y2 = 184;
        private static final Color panelColor = new Color(1977222);
        private static final Color lineColor = new Color(13691112);
        private String message;

        public FrontPanel() {
            this.setOpaque(false);
            this.message = "";
        }

        public void setMessage(String string) {
            this.message = string;
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = 0;
            int n2 = 25;
            int n3 = 75;
            int n4 = 125;
            int n5 = 152;
            graphics.setColor(lineColor);
            graphics.drawLine(34, 32 + n3, 334, 32 + n3);
            graphics.drawLine(34, 32 + n2, 334, 32 + n2);
            graphics.drawLine(34, 32 + n4, 334, 32 + n4);
            graphics.drawLine(34, 32 + n, 334, 32 + n5);
            graphics.drawLine(34, 32 + n5, 334, 32 + n);
            graphics.setColor(panelColor);
            graphics.fillRect(0, 0, 400, 24);
            graphics.fillRect(0, 192, 400, 400);
            graphics.fillRect(0, 0, 34, 400);
            graphics.fillRect(334, 0, 400, 400);
            if (this.message != null && this.message.trim().length() > 0) {
                graphics.setColor(Color.white);
                graphics.setFont(font);
                graphics.drawString(this.message, 120, 272);
            }
        }
    }
}

