/*
 * Decompiled with CFR 0.152.
 */
package slotmachine.graphic;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import slotmachine.graphic.GraphicReelElement;
import slotmachine.graphic.ReelRepaintTask;
import slotmachine.graphic.ReelRunningTask;
import slotmachine.graphic.ReelStopEffectTask;
import slotmachine.model.Reel;
import slotmachine.model.ReelElement;
import slotmachine.model.ReelPosition;

public class GraphicReel
extends JPanel
implements Reel,
Runnable {
    protected static final int WIDTH = 108;
    protected static final int HEIGHT = 220;
    private static final int DEGREE360 = 360;
    private static final int NUMBER_OF_ELEMENTS = 21;
    private static final double INTERVAL = 17.14285659790039;
    private static final double INCREMENTAL_VALUE = (double)0.32f;
    private static final long INTERVAL_REPAINT = 16L;
    private static final long INTERVAL_INCREMENT = 1L;
    private static final Color COLOR = new Color(0xEEEECC);
    private Timer timer;
    private GraphicReelElement[] elements;
    private double degree;
    private double degreeToStart;
    private double degreeToStop;
    private int stopPosition;
    private boolean active;
    private boolean stopRequested;
    private boolean stopDecided;

    public GraphicReel(GraphicReelElement[] graphicReelElementArray) {
        this.elements = graphicReelElementArray;
        this.degreeToStop = -1.0;
        this.active = false;
        this.stopRequested = false;
        this.stopDecided = false;
        this.setSize(108, 220);
        this.setBackground(Color.white);
        this.setOpaque(false);
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new ReelRepaintTask(this), 0L, 16L);
        this.timer.scheduleAtFixedRate((TimerTask)new ReelRunningTask(this), 0L, 1L);
        this.repaint();
    }

    public void run() {
        if (!this.stopDecided && this.active) {
            if (this.degreeToStart < (double)0.32f) {
                this.degreeToStart += 6.399999856948852E-4;
                this.setRelativeDegree(this.degreeToStart);
            } else {
                this.setRelativeDegree(0.32f);
            }
            if (this.stopRequested) {
                this.degreeToStop -= (double)0.32f;
                if (this.degreeToStop < 0.0) {
                    this.stopDecided = true;
                    new ReelStopEffectTask(this);
                    this.degreeToStart = 0.0;
                }
            }
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = 27;
        graphics.setColor(COLOR);
        graphics.fillRect(n, 0, 172, 220);
        double d = this.degree;
        int n2 = 0;
        int n3 = this.elements.length;
        while (n2 < n3) {
            if (d % 360.0 > 45.0 && d % 360.0 < 135.0) {
                int n4 = (int)(-Math.cos(Math.toRadians(d)) * (double)this.getHeight() * 0.75) + 78;
                graphics.drawImage(this.elements[n2].getImage(), n, n4, this);
            }
            ++n2;
            d += 17.14285659790039;
        }
    }

    public ReelElement[] getElements() {
        return this.elements;
    }

    public void requestStart() {
        this.active = true;
        this.stopRequested = false;
        this.stopDecided = false;
    }

    public void requestStop() {
        this.degreeToStop = 17.14285659790039 - this.degree % 17.14285659790039;
        this.stopRequested = true;
    }

    public boolean isStop() {
        return !this.active;
    }

    public ReelElement getElement(ReelPosition reelPosition) {
        this.stopPosition = this.getStopPosition();
        if (reelPosition.equals(ReelPosition.UPPER)) {
            return this.elements[this.stopPosition];
        }
        if (reelPosition.equals(ReelPosition.MIDDLE)) {
            if (this.stopPosition + 1 >= this.elements.length) {
                return this.elements[this.stopPosition - this.elements.length + 1];
            }
            return this.elements[this.stopPosition + 1];
        }
        if (reelPosition.equals(ReelPosition.LOWER)) {
            if (this.stopPosition + 2 >= this.elements.length) {
                return this.elements[this.stopPosition - this.elements.length + 2];
            }
            return this.elements[this.stopPosition + 2];
        }
        throw new IllegalArgumentException("pos : " + reelPosition);
    }

    protected void forceStop() {
        this.active = false;
        this.stopRequested = true;
        this.stopDecided = true;
    }

    private int getStopPosition() {
        int n = (int)((this.degree + 8.571428298950195) / 17.14285659790039);
        return (21 - n + 4) % 21;
    }

    public double getDegree() {
        return this.degree;
    }

    public void setDegree(double d) {
        this.setRelativeDegree(d - this.degree);
    }

    public void setRelativeDegree(double d) {
        double d2;
        double d3 = this.degree + d;
        this.degree = d2 = d3 < 0.0 ? 360.0 + d3 % 360.0 : d3 % 360.0;
    }
}

