/*
 * Decompiled with CFR 0.152.
 */
package slotmachine.console;

import java.util.Random;
import slotmachine.model.Reel;
import slotmachine.model.ReelElement;
import slotmachine.model.ReelPosition;

public class ConsoleReel
implements Reel {
    private static long seed = System.currentTimeMillis();
    private ReelElement[] elements;
    private boolean active;
    private int stopPosition;
    private Random random;

    public ConsoleReel(ReelElement[] reelElementArray) {
        this.elements = reelElementArray;
        this.random = new Random(--seed);
    }

    public ReelElement[] getElements() {
        return this.elements;
    }

    public void requestStart() {
        this.active = true;
    }

    public void requestStop() {
        this.stopPosition = this.getStopPosition();
        this.active = false;
    }

    public ReelElement getElement(ReelPosition reelPosition) {
        if (this.active) {
            this.stopPosition = this.getStopPosition();
        }
        if (reelPosition.equals(ReelPosition.UPPER)) {
            return this.elements[this.stopPosition];
        }
        if (reelPosition.equals(ReelPosition.MIDDLE)) {
            if (this.stopPosition + 1 >= this.elements.length) {
                return this.elements[this.stopPosition - this.elements.length + 1];
            }
            return this.elements[this.stopPosition + 1];
        }
        if (reelPosition.equals(ReelPosition.LOWER)) {
            if (this.stopPosition + 2 >= this.elements.length) {
                return this.elements[this.stopPosition - this.elements.length + 2];
            }
            return this.elements[this.stopPosition + 2];
        }
        throw new IllegalArgumentException("pos : " + reelPosition);
    }

    public boolean isStop() {
        return !this.active;
    }

    private int getStopPosition() {
        return this.random.nextInt(this.elements.length);
    }
}

