/*
 * Decompiled with CFR 0.152.
 */
package slotmachine;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JPanel;
import slotmachine.graphic.GraphicReelElement;
import slotmachine.graphic.GraphicSlotMachine;
import slotmachine.model.Prize;
import slotmachine.model.PrizeList;
import slotmachine.model.ReelElement;
import slotmachine.model.ReelElementGrid;

public final class GraphicView
extends JApplet
implements Runnable {
    private static final String TITLE = "SLOT MACHINE";
    private static final long INTERVAL_FROM_START_TO_STOP = 1000L;
    private static final int NUMBER_OF_LINES = 5;
    private static final PrizeList prizeList = new PrizeList();
    private GraphicSlotMachine machine;
    private boolean isRunning;
    private static final int DEFAULT_COIN = 100;
    private static final File dataFile;
    private File autoFile = new File(".", "auto");
    static /* synthetic */ Class class$slotmachine$graphic$GraphicSlotMachine;

    public GraphicView() {
        int n;
        this.setSize(360, 300);
        this.getContentPane().setBackground(Color.blue);
        this.machine = new GraphicSlotMachine(this);
        JPanel jPanel = new JPanel(null);
        jPanel.add(this.machine);
        this.machine.setBounds(0, 0, 400, 400);
        this.getContentPane().add(jPanel);
        try {
            n = GraphicView.loadCoins();
        }
        catch (IOException iOException) {
            n = 100;
        }
        this.machine.addCoin(n);
    }

    public void run() {
        if (!this.isRunning && this.machine.getCoins() > 0) {
            this.isRunning = true;
            do {
                this.play();
            } while (this.machine.getCoins() > 0 && this.isAutoMode());
            this.isRunning = false;
        }
        if (this.machine.getCoins() <= 0) {
            this.machine.showMessage("GAME OVER");
        }
    }

    private synchronized void play() {
        this.machine.showMessage("");
        this.machine.addCoin(-1);
        this.machine.requestStart();
        GraphicView.sleep(1000L);
        this.machine.requestStop();
        while (!this.machine.stoppedAll()) {
            GraphicView.sleep(200L);
        }
        ReelElementGrid reelElementGrid = this.machine.getReelElements();
        int n = 0;
        int n2 = 1;
        while (n2 <= 5) {
            n += GraphicView.getWonPrize(reelElementGrid, n2).getCoins();
            ++n2;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (n > 0) {
            printWriter.print(n);
            printWriter.print(" \u679a \u7372\u5f97\u3057\u307e\u3057\u305f");
        } else {
            printWriter.print("\u306f\u305a\u308c\u307e\u3057\u305f");
        }
        this.machine.showMessage(stringWriter.toString());
        this.machine.addCoin(n);
        try {
            GraphicView.saveCoins(this.machine.getCoins());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        GraphicView.sleep(500L);
    }

    private static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static int loadCoins() throws IOException {
        try {
            int n;
            FileReader fileReader = new FileReader(dataFile);
            try {
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                n = Integer.parseInt(bufferedReader.readLine());
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                fileReader.close();
                throw throwable;
            }
            fileReader.close();
            return n;
        }
        catch (RuntimeException runtimeException) {
            throw new IOException(runtimeException.getMessage());
        }
    }

    private static void saveCoins(int n) throws IOException {
        try {
            FileWriter fileWriter = new FileWriter(dataFile);
            try {
                PrintWriter printWriter = new PrintWriter(fileWriter);
                printWriter.print(n);
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                fileWriter.close();
                throw throwable;
            }
            fileWriter.close();
            {
            }
        }
        catch (RuntimeException runtimeException) {
            throw new IOException(runtimeException.getMessage());
        }
    }

    private synchronized boolean isAutoMode() {
        try {
            if (this.autoFile.isFile()) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    private static Prize getWonPrize(ReelElementGrid reelElementGrid, int n) {
        switch (n) {
            case 1: {
                return prizeList.getWonPrize(new ReelElement[]{reelElementGrid.get(0, 1), reelElementGrid.get(1, 1), reelElementGrid.get(2, 1)});
            }
            case 2: {
                return prizeList.getWonPrize(new ReelElement[]{reelElementGrid.get(0, 0), reelElementGrid.get(1, 0), reelElementGrid.get(2, 0)});
            }
            case 3: {
                return prizeList.getWonPrize(new ReelElement[]{reelElementGrid.get(0, 2), reelElementGrid.get(1, 2), reelElementGrid.get(2, 2)});
            }
            case 4: {
                return prizeList.getWonPrize(new ReelElement[]{reelElementGrid.get(0, 2), reelElementGrid.get(1, 1), reelElementGrid.get(2, 0)});
            }
            case 5: {
                return prizeList.getWonPrize(new ReelElement[]{reelElementGrid.get(0, 0), reelElementGrid.get(1, 1), reelElementGrid.get(2, 2)});
            }
        }
        throw new IllegalArgumentException("line : " + n);
    }

    public static Image loadImage(String string) {
        URL uRL = (class$slotmachine$graphic$GraphicSlotMachine == null ? (class$slotmachine$graphic$GraphicSlotMachine = GraphicView.class$("slotmachine.graphic.GraphicSlotMachine")) : class$slotmachine$graphic$GraphicSlotMachine).getResource("/" + string);
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        return image;
    }

    public static void main(String[] stringArray) {
        GraphicView graphicView = new GraphicView();
        JFrame jFrame = new JFrame();
        jFrame.setTitle(TITLE);
        ((Component)jFrame).setSize(graphicView.getWidth() + 16, graphicView.getHeight() + 16);
        jFrame.setResizable(false);
        jFrame.getContentPane().add(graphicView);
        jFrame.setDefaultCloseOperation(3);
        ((Frame)jFrame).setIconImage(GraphicView.loadImage("icon.gif"));
        ((Component)jFrame).setLocation(100, 100);
        jFrame.show();
        jFrame.validate();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        prizeList.addPrize(new Prize(new ReelElement[]{GraphicReelElement.SEVEN, GraphicReelElement.SEVEN, GraphicReelElement.SEVEN}, 500));
        prizeList.addPrize(new Prize(new ReelElement[]{GraphicReelElement.BAR, GraphicReelElement.BAR, GraphicReelElement.BAR}, 100));
        prizeList.addPrize(new Prize(new ReelElement[]{GraphicReelElement.DOLLAR, GraphicReelElement.DOLLAR, GraphicReelElement.DOLLAR}, 50));
        prizeList.addPrize(new Prize(new ReelElement[]{GraphicReelElement.BELL, GraphicReelElement.BELL, GraphicReelElement.BELL}, 10));
        prizeList.addPrize(new Prize(new ReelElement[]{GraphicReelElement.CHERRY, GraphicReelElement.CHERRY, GraphicReelElement.CHERRY}, 5));
        prizeList.addPrize(new Prize(new ReelElement[]{GraphicReelElement.CHERRY, GraphicReelElement.CHERRY, ReelElement.ANY}, 1));
        dataFile = new File(".", "coins");
    }
}

