/*
 * Decompiled with CFR 0.152.
 */
package slotmachine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import slotmachine.console.ConsoleReelElement;
import slotmachine.console.ConsoleSlotMachine;
import slotmachine.model.Prize;
import slotmachine.model.PrizeList;
import slotmachine.model.Reel;
import slotmachine.model.ReelElement;
import slotmachine.model.ReelElementGrid;

public final class ConsoleView {
    private static final PrizeList prizeList = new PrizeList();
    private static final int DEFAULT_COIN = 100;
    private static final File dataFile;
    private static final BufferedReader reader;
    private static final PrintStream out;
    private static final String SEPARATOR = "----------------";
    private static final String EMPTY = "";
    private static final int NUMBER_OF_LINES = 5;

    private static void printStopElements(ReelElementGrid reelElementGrid) {
        out.println(" ----------------");
        out.print(" | ");
        out.print(reelElementGrid.get(0, 0));
        out.print(" | ");
        out.print(reelElementGrid.get(1, 0));
        out.print(" | ");
        out.print(reelElementGrid.get(2, 0));
        out.print(" | ");
        out.println();
        out.print(" | ");
        out.print(reelElementGrid.get(0, 1));
        out.print(" | ");
        out.print(reelElementGrid.get(1, 1));
        out.print(" | ");
        out.print(reelElementGrid.get(2, 1));
        out.print(" | ");
        out.println();
        out.print(" | ");
        out.print(reelElementGrid.get(0, 2));
        out.print(" | ");
        out.print(reelElementGrid.get(1, 2));
        out.print(" | ");
        out.print(reelElementGrid.get(2, 2));
        out.print(" | ");
        out.println();
        out.println(" ----------------");
    }

    private static String getInput(String string) {
        out.print(string);
        try {
            return reader.readLine();
        }
        catch (IOException iOException) {
            return EMPTY;
        }
    }

    private static Prize getWonPrize(ReelElementGrid reelElementGrid, int n) {
        switch (n) {
            case 1: {
                return prizeList.getWonPrize(new ReelElement[]{reelElementGrid.get(0, 1), reelElementGrid.get(1, 1), reelElementGrid.get(2, 1)});
            }
            case 2: {
                return prizeList.getWonPrize(new ReelElement[]{reelElementGrid.get(0, 0), reelElementGrid.get(1, 0), reelElementGrid.get(2, 0)});
            }
            case 3: {
                return prizeList.getWonPrize(new ReelElement[]{reelElementGrid.get(0, 2), reelElementGrid.get(1, 2), reelElementGrid.get(2, 2)});
            }
            case 4: {
                return prizeList.getWonPrize(new ReelElement[]{reelElementGrid.get(0, 2), reelElementGrid.get(1, 1), reelElementGrid.get(2, 0)});
            }
            case 5: {
                return prizeList.getWonPrize(new ReelElement[]{reelElementGrid.get(0, 0), reelElementGrid.get(1, 1), reelElementGrid.get(2, 2)});
            }
        }
        throw new IllegalArgumentException("line : " + n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int loadCoins() throws IOException {
        int n;
        FileReader fileReader = new FileReader(dataFile);
        try {
            try {
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                n = Integer.parseInt(bufferedReader.readLine());
                Object var4_4 = null;
            }
            catch (RuntimeException runtimeException) {
                throw new IOException(runtimeException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            fileReader.close();
            throw throwable;
        }
        fileReader.close();
        return n;
    }

    private static void saveCoins(int n) throws IOException {
        FileWriter fileWriter = new FileWriter(dataFile);
        try {
            try {
                PrintWriter printWriter = new PrintWriter(fileWriter);
                printWriter.print(n);
            }
            catch (RuntimeException runtimeException) {
                throw new IOException(runtimeException.getMessage());
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            fileWriter.close();
            throw throwable;
        }
        fileWriter.close();
    }

    private static void tryOut(int n) {
        Object object;
        Object object2;
        Object object3;
        ConsoleSlotMachine consoleSlotMachine = new ConsoleSlotMachine();
        int n2 = 0;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        int n3 = 0;
        int n4 = prizeList.size();
        while (n3 < n4) {
            hashMap.put(prizeList.get(n3), new Integer(0));
            ++n3;
        }
        if (n == 0) {
            Reel[] reelArray = consoleSlotMachine.getReels();
            object3 = reelArray[0].getElements();
            object2 = reelArray[1].getElements();
            object = reelArray[2].getElements();
            int n5 = 0;
            while (n5 < ((ReelElement[])object3).length) {
                int n6 = 0;
                while (n6 < ((ReelElement[])object2).length) {
                    int n7 = 0;
                    while (n7 < ((Object)object).length) {
                        ReelElement[] reelElementArray = new ReelElement[]{object3[n5], object3[(n5 + 1) % 21], object3[(n5 + 2) % 21]};
                        ReelElement[] reelElementArray2 = new ReelElement[]{object2[n6], object2[(n6 + 1) % 21], object2[(n6 + 2) % 21]};
                        ReelElement[] reelElementArray3 = new ReelElement[]{object[n7], object[(n7 + 1) % 21], object[(n7 + 2) % 21]};
                        ReelElementGrid reelElementGrid = new ReelElementGrid(new ReelElement[][]{reelElementArray, reelElementArray2, reelElementArray3});
                        int n8 = 1;
                        while (n8 <= 5) {
                            Prize prize = ConsoleView.getWonPrize(reelElementGrid, n8);
                            n2 += prize.getCoins();
                            Integer n9 = (Integer)hashMap.get(prize);
                            if (n9 != null) {
                                hashMap.put(prize, new Integer(n9 + 1));
                            }
                            ++n8;
                        }
                        ++n;
                        ++n7;
                    }
                    ++n6;
                }
                ++n5;
            }
        } else {
            int n10 = 0;
            while (n10 < n) {
                consoleSlotMachine.requestStart();
                do {
                    consoleSlotMachine.requestStop();
                } while (!consoleSlotMachine.stoppedAll());
                object3 = consoleSlotMachine.getReelElements();
                int n11 = 1;
                while (n11 <= 5) {
                    object = ConsoleView.getWonPrize((ReelElementGrid)object3, n11);
                    n2 += ((Prize)object).getCoins();
                    Integer n12 = (Integer)hashMap.get(object);
                    if (n12 != null) {
                        hashMap.put(object, new Integer(n12 + 1));
                    }
                    ++n11;
                }
                ++n10;
            }
        }
        out.println("            \u8a66\u884c\u7d50\u679c");
        out.println("--------------------------------");
        int n13 = 0;
        int n14 = prizeList.size();
        while (n13 < n14) {
            object2 = prizeList.getPrize(n13);
            object = (Integer)hashMap.get(object2);
            out.print(object2);
            out.print(" : ");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(object);
            while (stringBuffer.length() <= String.valueOf(n).length()) {
                stringBuffer.insert(0, ' ');
            }
            out.print(stringBuffer);
            out.println(" \u56de");
            ++n13;
        }
        out.println("--------------------------------");
        out.println("  \u8a66\u884c\u56de\u6570 : " + n + " \u56de");
        out.println("  \u7372\u5f97\u679a\u6570 : " + n2 + " \u679a");
        out.println("  \u671f\u5f85\u5024\u7387 : " + 100.0f * (float)n2 / (float)n + " %");
        out.println("--------------------------------");
    }

    public static void main(String[] stringArray) {
        int n;
        out.println();
        out.println("--------------------------------");
        out.println("         SLOT  MACHINE");
        out.println("--------------------------------");
        if (stringArray.length > 0) {
            try {
                ConsoleView.tryOut(Integer.parseInt(stringArray[0]));
                System.exit(0);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ConsoleSlotMachine consoleSlotMachine = new ConsoleSlotMachine();
        try {
            n = ConsoleView.loadCoins();
        }
        catch (IOException iOException) {
            n = 100;
        }
        out.println("  \u25bc \u5165\u8cde\u30ea\u30b9\u30c8 \u25bc");
        out.print(prizeList);
        out.println("--------------------------------");
        while (true) {
            out.print("\u73fe\u5728\u306e\u6301\u3061\u30b3\u30a4\u30f3\u6570 : ");
            out.println(n);
            if (n <= 0) {
                out.println("GAME OVER!");
                break;
            }
            String string = ConsoleView.getInput("( ENTER\u3067\u5b9f\u884c, \u4f55\u304b\u5165\u529b\u3067\u7d42\u4e86 ) > ");
            if (!string.equals(EMPTY)) break;
            --n;
            consoleSlotMachine.requestStart();
            do {
                consoleSlotMachine.requestStop();
            } while (!consoleSlotMachine.stoppedAll());
            ReelElementGrid reelElementGrid = consoleSlotMachine.getReelElements();
            ConsoleView.printStopElements(reelElementGrid);
            int n2 = 0;
            int n3 = 1;
            while (n3 <= 5) {
                n2 += ConsoleView.getWonPrize(reelElementGrid, n3).getCoins();
                ++n3;
            }
            if (n2 > 0) {
                out.print(n2);
                out.println(" \u679a \u7372\u5f97\u3057\u307e\u3057\u305f");
                out.println();
                n += n2;
            } else {
                out.println("\u306f\u305a\u308c\u307e\u3057\u305f");
                out.println();
            }
            try {
                ConsoleView.saveCoins(n);
            }
            catch (IOException iOException) {}
        }
    }

    static {
        prizeList.addPrize(new Prize(new ReelElement[]{ConsoleReelElement.SEVEN, ConsoleReelElement.SEVEN, ConsoleReelElement.SEVEN}, 500));
        prizeList.addPrize(new Prize(new ReelElement[]{ConsoleReelElement.BAR, ConsoleReelElement.BAR, ConsoleReelElement.BAR}, 100));
        prizeList.addPrize(new Prize(new ReelElement[]{ConsoleReelElement.DOLLAR, ConsoleReelElement.DOLLAR, ConsoleReelElement.DOLLAR}, 50));
        prizeList.addPrize(new Prize(new ReelElement[]{ConsoleReelElement.BELL, ConsoleReelElement.BELL, ConsoleReelElement.BELL}, 10));
        prizeList.addPrize(new Prize(new ReelElement[]{ConsoleReelElement.CHERRY, ConsoleReelElement.CHERRY, ConsoleReelElement.CHERRY}, 5));
        prizeList.addPrize(new Prize(new ReelElement[]{ConsoleReelElement.CHERRY, ConsoleReelElement.CHERRY, ReelElement.ANY}, 1));
        dataFile = new File(".", "coins");
        reader = new BufferedReader(new InputStreamReader(System.in));
        out = System.out;
    }
}

