package logicirc.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

import logicirc.core.AndCircuit;
import logicirc.core.CircuitAdapter;
import logicirc.core.DoubleInputCircuit;
import logicirc.core.DoubleInputSocket;
import logicirc.core.LogicalCircuit;
import logicirc.core.OrCircuit;
import logicirc.core.SingleInputCircuit;
import logicirc.core.Voltage;
import logicirc.core.XorCircuit;

/**
 * _HV~[^̃CNXłB
 */
public final class LogicalCircuitSimulator extends JFrame {

    /**
     * _HV~[^̃EBhE܂B
     */
    public LogicalCircuitSimulator() {

        // _H
        CircuitBoard board = new CircuitBoard();

        // t[̂̐ݒ
        setTitle("_HV~[^");
        setSize(480, 320);
        setLocation(100, 100);
        setResizable(false);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        // RecyC̐ݒ
        getContentPane().setBackground(Color.white);
        getContentPane().setLayout(null);

        // CAEgpi
        JPanel mainPanel = new JPanel(null);
        getContentPane().add(mainPanel);
        mainPanel.setBounds(32, 8, 420, 320);
        mainPanel.setOpaque(false);
        Rectangle rect = new Rectangle(16, 16, 24, 24);

        // ͕̐ݒ
        BitPanel[] input = new BitPanel[8];
        for (int i = 0; i < input.length; i++) {
            CircuitAdapter adapter = board.getAdapter(i / 2, i % 2);
            input[i] = new BitPanel(adapter.getOutput());
            input[i].setBounds(rect);
            input[i].addMouseListener(new OnBitPanelClicked(board, adapter));
            mainPanel.add(input[i]);
            board.addBoardStateListener(input[i]);
            rect.y += 32;
        }

        // o͕̐ݒ
        BitPanel[] output = new BitPanel[7];
        for (int i = 0; i < output.length; i++) {
            LogicalCircuit circuit = board.getCircuit(i);
            output[i] = new BitPanel(circuit);
            mainPanel.add(output[i]);
            board.addBoardStateListener(output[i]);
            switch (i) {
                case 0:
                    rect.x = 128;
                    rect.y = 32;
                    break;
                case 1:
                    rect.x = 128;
                    rect.y = 96;
                    break;
                case 2:
                    rect.x = 128;
                    rect.y = 160;
                    break;
                case 3:
                    rect.x = 128;
                    rect.y = 224;
                    break;
                case 4:
                    rect.x = 256;
                    rect.y = 64;
                    break;
                case 5:
                    rect.x = 256;
                    rect.y = 192;
                    break;
                case 6:
                    rect.x = 384;
                    rect.y = 128;
                    break;
            }
            output[i].setBounds(rect);
        }

        // _H̐ݒ
        rect.width = 64;
        rect.height = 64;
        CircuitPanel[] panel = new CircuitPanel[7];
        for (int i = 0; i < panel.length; i++) {
            DoubleInputCircuit circuit;
            switch (i) {
                case 0:
                case 1:
                case 2:
                case 3:
                    circuit = new XorCircuit();
                    break;
                case 4:
                case 5:
                    circuit = new AndCircuit();
                    break;
                case 6:
                    circuit = new OrCircuit();
                    break;
                default:
                    circuit = null;
            }

            DoubleInputSocket socket = board.getDoubleInputCircuitSocket(i);
            socket.setCircuit(circuit);
            panel[i] = new CircuitPanel(socket);

            switch (i) {
                case 0:
                    rect.x = 52;
                    rect.y = 12;
                    break;
                case 1:
                    rect.x = 52;
                    rect.y = 76;
                    break;
                case 2:
                    rect.x = 52;
                    rect.y = 140;
                    break;
                case 3:
                    rect.x = 52;
                    rect.y = 204;
                    break;
                case 4:
                    rect.x = 174;
                    rect.y = 42;
                    break;
                case 5:
                    rect.x = 174;
                    rect.y = 172;
                    break;
                case 6:
                    rect.x = 300;
                    rect.y = 107;
                    break;
            }
            mainPanel.add(panel[i]);
            panel[i].setBounds(rect);
            panel[i].addMouseListener(new OnCircuitPanelClicked(board, socket));

            board.addBoardStateListener(panel[i]);

        }

        // z̐ݒ
        JComponent wirePattern = new JComponent() {

            protected void paintComponent(Graphics g) {

                super.paintComponent(g);

                // Pړ
                g.drawLine(24, 21, 40, 21);
                g.drawLine(24, 51, 40, 51);
                g.drawLine(24, 85, 40, 85);
                g.drawLine(24, 115, 40, 115);
                g.drawLine(24, 149, 40, 149);
                g.drawLine(24, 179, 40, 179);
                g.drawLine(24, 213, 40, 213);
                g.drawLine(24, 243, 40, 243);
                // Pڏo
                g.drawLine(100, 36, 112, 36);
                g.drawLine(100, 100, 112, 100);
                g.drawLine(100, 164, 112, 164);
                g.drawLine(100, 228, 112, 228);
                // Qړ
                g.drawLine(136, 36, 160, 53);
                g.drawLine(136, 100, 160, 78);
                g.drawLine(136, 163, 160, 184);
                g.drawLine(136, 228, 160, 209);
                // Qڏo
                g.drawLine(221, 66, 241, 66);
                g.drawLine(221, 196, 240, 196);
                // Rړ
                g.drawLine(263, 68, 283, 116);
                g.drawLine(263, 197, 283, 146);
                // Rڏo
                g.drawLine(348, 131, 368, 131);

            }

        };
        mainPanel.add(wirePattern);
        wirePattern.setBounds(16, 8, 400, 300);

        // ŐV\
        board.fireChangeState();

    }

    /**
     * dplłB<br>
     * <br>
     * d̏Ԃ\܂B \ȃplƕ\p̂Qނ˂Ă܂B
     */
    static class BitPanel extends JComponent implements BoardStateListener {

        /** ͉\pl̐FłB */
        static final Color LIGHT_YELLOW = new Color(255, 255, 127);

        Color color;
        LogicalCircuit circuit;
        boolean state;

        /**
         * \ȓdpl𐶐܂B
         * @param state Ԃ̏li <code>1</code> Ȃ <code>true</code>A
         *            <code>0</code> Ȃ <code>false</code>j
         */
        BitPanel(boolean state) {

            this.state = state;
            color = LIGHT_YELLOW;

        }

        /**
         * \p̓dpl𐶐܂B
         * @param circuit Ώۂ̘_H
         */
        BitPanel(LogicalCircuit circuit) {

            this.circuit = circuit;
            color = Color.white;

        }

        /*
         * ( Javadoc)
         * @see logicirc.view.BoardStateListener#stateChanged(logicirc.view.BoardStateEvent)
         */
        public void stateChanged(BoardStateEvent e) {

            if (circuit != null) {
                state = circuit.getOutput();
            }
            repaint();

        }

        /**
         * Ԃւ܂B <code>1</code> Ȃ <code>0</code>ɁA<code>0</code>
         * Ȃ <code>1</code> ɂȂ܂B
         */
        void swapState() {

            state = !state;
            repaint();

        }

        /**
         * Ԃ擾܂B
         * @return <code>1</code> Ȃ <code>true</code>A<code>0</code> Ȃ
         *         <code>false</code>
         */
        boolean getState() {

            return state;

        }

        /*
         * ( Javadoc)
         * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
         */
        protected void paintComponent(Graphics g) {

            super.paintComponent(g);

            g.setColor(color);
            g.fillRect(0, 0, 23, 23);
            g.setColor(Color.black);
            g.drawRect(0, 0, 23, 23);
            g.drawString((state ? "1" : "0"), 8, 16);

        }

    }

    /**
     * _HplłB<br>
     * <br>
     * _H̏Ԃ\܂B
     */
    static class CircuitPanel extends JComponent implements BoardStateListener {

        static ImageIcon GIF_AND;
        static ImageIcon GIF_OR;
        static ImageIcon GIF_XOR;

        DoubleInputSocket socket;

        /**
         * CircuitPanel𐶐܂B
         * @param socket Ή_H̃\Pbg
         */
        CircuitPanel(DoubleInputSocket socket) {

            this.socket = socket;

            Class c = getClass();
            GIF_AND = new ImageIcon(c.getResource("/logicirc/images/AND.gif"));
            GIF_OR = new ImageIcon(c.getResource("/logicirc/images/OR.gif"));
            GIF_XOR = new ImageIcon(c.getResource("/logicirc/images/XOR.gif"));

        }

        /*
         * ( Javadoc)
         * @see logicirc.view.BoardStateListener#stateChanged(logicirc.view.BoardStateEvent)
         */
        public void stateChanged(BoardStateEvent e) {

            repaint();

        }

        /*
         * ( Javadoc)
         * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
         */
        protected void paintComponent(Graphics g) {

            super.paintComponent(g);

            DoubleInputCircuit circuit = socket.getCircuit();
            Image image;
            if (circuit instanceof AndCircuit) {
                image = GIF_AND.getImage();
            } else if (circuit instanceof OrCircuit) {
                image = GIF_OR.getImage();
            } else if (circuit instanceof XorCircuit) {
                image = GIF_XOR.getImage();
            } else {
                image = GIF_AND.getImage();
            }
            g.drawImage(image, 0, 0, null);

        }

    }

    /**
     * dplNbNꂽƂ̃CxgłB
     */
    static class OnBitPanelClicked extends MouseAdapter {

        CircuitBoard board;
        SingleInputCircuit circuit;

        /**
         * OnClickedBitPanel𐶐܂B
         * @param board H
         * @param circuit Ή_H
         */
        OnBitPanelClicked(CircuitBoard board, SingleInputCircuit circuit) {

            this.board = board;
            this.circuit = circuit;

        }

        /*
         * ( Javadoc)
         * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
         */
        public void mouseClicked(MouseEvent e) {

            BitPanel b = (BitPanel)e.getSource();
            b.swapState();
            circuit.setInput((b.getState() ? Voltage.HIGH : Voltage.LOW));
            board.fireChangeState();

        }

    }

    /**
     * _HplNbNꂽƂ̃CxgłB
     */
    static class OnCircuitPanelClicked extends MouseAdapter {

        CircuitBoard board;
        DoubleInputSocket socket;

        /**
         * OnClickedCircuitPanel𐶐܂B
         * @param board H
         * @param socket Ή_H̃\Pbg
         */
        OnCircuitPanelClicked(CircuitBoard board, DoubleInputSocket socket) {

            this.board = board;
            this.socket = socket;
            
        }

        /*
         * ( Javadoc)
         * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
         */
        public void mouseClicked(MouseEvent e) {

            DoubleInputCircuit circuit = socket.getCircuit();
            if (circuit instanceof AndCircuit) {
                socket.setCircuit(new OrCircuit());
            } else if (circuit instanceof OrCircuit) {
                socket.setCircuit(new XorCircuit());
            } else if (circuit instanceof XorCircuit) {
                socket.setCircuit(new AndCircuit());
            }

            board.fireChangeState();

        }

    }

    /**
     * _HV~[^N܂B
     * @param args
     */
    public static void main(String[] args) {

        JFrame frame = new LogicalCircuitSimulator();
        frame.show();
        
    }

}

